@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property commonAttributes Describes the metadata sent to the HTTP endpoint destination. See `common_attributes` block below for details.
 * @property contentEncoding Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination. Valid values are `NONE` and `GZIP`.  Default value is `NONE`.
 */
public data class FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration(
    public val commonAttributes: List<FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttribute>? =
        null,
    public val contentEncoding: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration): FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration =
            FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfiguration(
                commonAttributes = javaType.commonAttributes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamHttpEndpointConfigurationRequestConfigurationCommonAttribute.Companion.toKotlin(args0)
                    })
                }),
                contentEncoding = javaType.contentEncoding().map({ args0 -> args0 }).orElse(null),
            )
    }
}
