@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticationConfiguration The authentication configuration of the Amazon MSK cluster. See `authentication_configuration` block below for details.
 * @property mskClusterArn The ARN of the Amazon MSK cluster.
 * @property topicName The topic name within the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamMskSourceConfiguration(
    public val authenticationConfiguration: FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration,
    public val mskClusterArn: String,
    public val topicName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamMskSourceConfiguration): FirehoseDeliveryStreamMskSourceConfiguration = FirehoseDeliveryStreamMskSourceConfiguration(
            authenticationConfiguration = javaType.authenticationConfiguration().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration.Companion.toKotlin(args0)
            }),
            mskClusterArn = javaType.mskClusterArn(),
            topicName = javaType.topicName(),
        )
    }
}
