@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property connectivity The type of connectivity used to access the Amazon MSK cluster. Valid values: `PUBLIC`, `PRIVATE`.
 * @property roleArn The ARN of the role used to access the Amazon MSK cluster.
 */
public data class FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration(
    public val connectivity: String,
    public val roleArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration): FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration =
            FirehoseDeliveryStreamMskSourceConfigurationAuthenticationConfiguration(
                connectivity = javaType.connectivity(),
                roleArn = javaType.roleArn(),
            )
    }
}
