@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property clusterJdbcurl The jdbcurl of the redshift cluster.
 * @property copyOptions Copy options for copying the data from the s3 intermediate bucket into redshift, for example to change the default delimiter. For valid values, see the [AWS documentation](http://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html)
 * @property dataTableColumns The data table columns that will be targeted by the copy command.
 * @property dataTableName The name of the table in the redshift cluster that the s3 bucket will copy to.
 * @property password The password for the username above. This value is required if `secrets_manager_configuration` is not provided.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property retryDuration The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt. The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of DurationInSeconds is 0 (zero) or if the first delivery attempt takes longer than the current value.
 * @property roleArn The arn of the role the stream assumes.
 * @property s3BackupConfiguration The configuration for backup in Amazon S3. Required if `s3_backup_mode` is `Enabled`. Supports the same fields as `s3_configuration` object.
 * `secrets_manager_configuration` - (Optional) The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `username` and `password` are not provided.
 * @property s3BackupMode The Amazon S3 backup mode.  Valid values are `Disabled` and `Enabled`.  Default value is `Disabled`.
 * @property s3Configuration The S3 Configuration. See s3_configuration below for details.
 * @property secretsManagerConfiguration
 * @property username The username that the firehose delivery stream will assume. It is strongly recommended that the username and password provided is used exclusively for Amazon Kinesis Firehose purposes, and that the permissions for the account are restricted for Amazon Redshift INSERT permissions. This value is required if `secrets_manager_configuration` is not provided.
 */
public data class FirehoseDeliveryStreamRedshiftConfiguration(
    public val cloudwatchLoggingOptions: FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptions? = null,
    public val clusterJdbcurl: String,
    public val copyOptions: String? = null,
    public val dataTableColumns: String? = null,
    public val dataTableName: String,
    public val password: String? = null,
    public val processingConfiguration: FirehoseDeliveryStreamRedshiftConfigurationProcessingConfiguration? = null,
    public val retryDuration: Int? = null,
    public val roleArn: String,
    public val s3BackupConfiguration: FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfiguration? = null,
    public val s3BackupMode: String? = null,
    public val s3Configuration: FirehoseDeliveryStreamRedshiftConfigurationS3Configuration,
    public val secretsManagerConfiguration: FirehoseDeliveryStreamRedshiftConfigurationSecretsManagerConfiguration? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamRedshiftConfiguration): FirehoseDeliveryStreamRedshiftConfiguration = FirehoseDeliveryStreamRedshiftConfiguration(
            cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterJdbcurl = javaType.clusterJdbcurl(),
            copyOptions = javaType.copyOptions().map({ args0 -> args0 }).orElse(null),
            dataTableColumns = javaType.dataTableColumns().map({ args0 -> args0 }).orElse(null),
            dataTableName = javaType.dataTableName(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            s3BackupConfiguration = javaType.s3BackupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfigurationS3BackupConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
            s3Configuration = javaType.s3Configuration().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfigurationS3Configuration.Companion.toKotlin(args0)
            }),
            secretsManagerConfiguration = javaType.secretsManagerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamRedshiftConfigurationSecretsManagerConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
