@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountUrl The URL of the Snowflake account. Format: https://[account_identifier].snowflakecomputing.com.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property contentColumnName The name of the content column.
 * @property dataLoadingOption The data loading option.
 * @property database The Snowflake database name.
 * @property keyPassphrase The passphrase for the private key.
 * @property metadataColumnName The name of the metadata column.
 * @property privateKey The private key for authentication. This value is required if `secrets_manager_configuration` is not provided.
 * @property processingConfiguration The processing configuration. See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to Snowflake, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 60s.  There will be no retry if the value is 0.
 * @property roleArn The ARN of the IAM role.
 * @property s3BackupMode The S3 backup mode.
 * @property s3Configuration The S3 configuration. See `s3_configuration` block below for details.
 * @property schema The Snowflake schema name.
 * @property secretsManagerConfiguration The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `user` and `private_key` are not provided.
 * @property snowflakeRoleConfiguration The configuration for Snowflake role.
 * @property snowflakeVpcConfiguration The VPC configuration for Snowflake.
 * @property table The Snowflake table name.
 * @property user The user for authentication. This value is required if `secrets_manager_configuration` is not provided.
 */
public data class FirehoseDeliveryStreamSnowflakeConfiguration(
    public val accountUrl: String,
    public val cloudwatchLoggingOptions: FirehoseDeliveryStreamSnowflakeConfigurationCloudwatchLoggingOptions? = null,
    public val contentColumnName: String? = null,
    public val dataLoadingOption: String? = null,
    public val database: String,
    public val keyPassphrase: String? = null,
    public val metadataColumnName: String? = null,
    public val privateKey: String? = null,
    public val processingConfiguration: FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfiguration? = null,
    public val retryDuration: Int? = null,
    public val roleArn: String,
    public val s3BackupMode: String? = null,
    public val s3Configuration: FirehoseDeliveryStreamSnowflakeConfigurationS3Configuration,
    public val schema: String,
    public val secretsManagerConfiguration: FirehoseDeliveryStreamSnowflakeConfigurationSecretsManagerConfiguration? = null,
    public val snowflakeRoleConfiguration: FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfiguration? = null,
    public val snowflakeVpcConfiguration: FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfiguration? = null,
    public val table: String,
    public val user: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamSnowflakeConfiguration): FirehoseDeliveryStreamSnowflakeConfiguration = FirehoseDeliveryStreamSnowflakeConfiguration(
            accountUrl = javaType.accountUrl(),
            cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentColumnName = javaType.contentColumnName().map({ args0 -> args0 }).orElse(null),
            dataLoadingOption = javaType.dataLoadingOption().map({ args0 -> args0 }).orElse(null),
            database = javaType.database(),
            keyPassphrase = javaType.keyPassphrase().map({ args0 -> args0 }).orElse(null),
            metadataColumnName = javaType.metadataColumnName().map({ args0 -> args0 }).orElse(null),
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
            roleArn = javaType.roleArn(),
            s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
            s3Configuration = javaType.s3Configuration().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationS3Configuration.Companion.toKotlin(args0)
            }),
            schema = javaType.schema(),
            secretsManagerConfiguration = javaType.secretsManagerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationSecretsManagerConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snowflakeRoleConfiguration = javaType.snowflakeRoleConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeRoleConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            snowflakeVpcConfiguration = javaType.snowflakeVpcConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSnowflakeConfigurationSnowflakeVpcConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            table = javaType.table(),
            user = javaType.user().map({ args0 -> args0 }).orElse(null),
        )
    }
}
