@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bufferingInterval Buffer incoming data for the specified period of time, in seconds between 0 to 60, before delivering it to the destination.  The default value is 60s.
 * @property bufferingSize Buffer incoming data to the specified size, in MBs between 1 to 5, before delivering it to the destination.  The default value is 5MB.
 * @property cloudwatchLoggingOptions The CloudWatch Logging Options for the delivery stream. See `cloudwatch_logging_options` block below for details.
 * @property hecAcknowledgmentTimeout The amount of time, in seconds between 180 and 600, that Kinesis Firehose waits to receive an acknowledgment from Splunk after it sends it data.
 * @property hecEndpoint The HTTP Event Collector (HEC) endpoint to which Kinesis Firehose sends your data.
 * @property hecEndpointType The HEC endpoint type. Valid values are `Raw` or `Event`. The default value is `Raw`.
 * @property hecToken The GUID that you obtain from your Splunk cluster when you create a new HEC endpoint. This value is required if `secrets_manager_configuration` is not provided.
 * @property processingConfiguration The data processing configuration.  See `processing_configuration` block below for details.
 * @property retryDuration After an initial failure to deliver to Splunk, the total amount of time, in seconds between 0 to 7200, during which Firehose re-attempts delivery (including the first attempt).  After this time has elapsed, the failed documents are written to Amazon S3.  The default value is 300s.  There will be no retry if the value is 0.
 * @property s3BackupMode Defines how documents should be delivered to Amazon S3.  Valid values are `FailedEventsOnly` and `AllEvents`.  Default value is `FailedEventsOnly`.
 * `secrets_manager_configuration` - (Optional) The Secrets Manager configuration. See `secrets_manager_configuration` block below for details. This value is required if `hec_token` is not provided.
 * @property s3Configuration The S3 Configuration. See `s3_configuration` block below for details.
 * @property secretsManagerConfiguration
 */
public data class FirehoseDeliveryStreamSplunkConfiguration(
    public val bufferingInterval: Int? = null,
    public val bufferingSize: Int? = null,
    public val cloudwatchLoggingOptions: FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions? = null,
    public val hecAcknowledgmentTimeout: Int? = null,
    public val hecEndpoint: String,
    public val hecEndpointType: String? = null,
    public val hecToken: String? = null,
    public val processingConfiguration: FirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration? = null,
    public val retryDuration: Int? = null,
    public val s3BackupMode: String? = null,
    public val s3Configuration: FirehoseDeliveryStreamSplunkConfigurationS3Configuration,
    public val secretsManagerConfiguration: FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamSplunkConfiguration): FirehoseDeliveryStreamSplunkConfiguration = FirehoseDeliveryStreamSplunkConfiguration(
            bufferingInterval = javaType.bufferingInterval().map({ args0 -> args0 }).orElse(null),
            bufferingSize = javaType.bufferingSize().map({ args0 -> args0 }).orElse(null),
            cloudwatchLoggingOptions = javaType.cloudwatchLoggingOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationCloudwatchLoggingOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hecAcknowledgmentTimeout = javaType.hecAcknowledgmentTimeout().map({ args0 -> args0 }).orElse(null),
            hecEndpoint = javaType.hecEndpoint(),
            hecEndpointType = javaType.hecEndpointType().map({ args0 -> args0 }).orElse(null),
            hecToken = javaType.hecToken().map({ args0 -> args0 }).orElse(null),
            processingConfiguration = javaType.processingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryDuration = javaType.retryDuration().map({ args0 -> args0 }).orElse(null),
            s3BackupMode = javaType.s3BackupMode().map({ args0 -> args0 }).orElse(null),
            s3Configuration = javaType.s3Configuration().let({ args0 ->
                com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationS3Configuration.Companion.toKotlin(args0)
            }),
            secretsManagerConfiguration = javaType.secretsManagerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
