@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property parameters Specifies the processor parameters as multiple blocks. See `parameters` block below for details.
 * @property type The type of processor. Valid Values: `RecordDeAggregation`, `Lambda`, `MetadataExtraction`, `AppendDelimiterToRecord`. Validation is done against [AWS SDK constants](https://docs.aws.amazon.com/sdk-for-go/api/service/firehose/#pkg-constants); so that values not explicitly listed may also work.
 */
public data class FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessor(
    public val parameters: List<FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorParameter>? =
        null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessor): FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessor =
            FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessor(
                parameters = javaType.parameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.FirehoseDeliveryStreamSplunkConfigurationProcessingConfigurationProcessorParameter.Companion.toKotlin(args0)
                    })
                }),
                type = javaType.type(),
            )
    }
}
