@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Enables or disables the Secrets Manager configuration.
 * @property roleArn The ARN of the role the stream assumes.
 * @property secretArn The ARN of the Secrets Manager secret. This value is required if `enabled` is true.
 */
public data class FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration(
    public val enabled: Boolean? = null,
    public val roleArn: String? = null,
    public val secretArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration): FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration =
            FirehoseDeliveryStreamSplunkConfigurationSecretsManagerConfiguration(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                roleArn = javaType.roleArn().map({ args0 -> args0 }).orElse(null),
                secretArn = javaType.secretArn().map({ args0 -> args0 }).orElse(null),
            )
    }
}
