@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getFirehoseDeliveryStream.
 * @property arn ARN of the Kinesis Stream (same as id).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetFirehoseDeliveryStreamResult(
    public val arn: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.GetFirehoseDeliveryStreamResult): GetFirehoseDeliveryStreamResult = GetFirehoseDeliveryStreamResult(
            arn = javaType.arn(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
