@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getStreamConsumer.
 * @property arn
 * @property creationTimestamp Approximate timestamp in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) of when the stream consumer was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property status Current status of the stream consumer.
 * @property streamArn
 */
public data class GetStreamConsumerResult(
    public val arn: String,
    public val creationTimestamp: String,
    public val id: String,
    public val name: String,
    public val status: String,
    public val streamArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.GetStreamConsumerResult): GetStreamConsumerResult = GetStreamConsumerResult(
            arn = javaType.arn(),
            creationTimestamp = javaType.creationTimestamp(),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status(),
            streamArn = javaType.streamArn(),
        )
    }
}
