@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesis.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getStream.
 * @property arn ARN of the Kinesis Stream (same as id).
 * @property closedShards List of shard ids in the CLOSED state. See [Shard State](https://docs.aws.amazon.com/streams/latest/dev/kinesis-using-sdk-java-after-resharding.html#kinesis-using-sdk-java-resharding-data-routing) for more.
 * @property creationTimestamp Approximate UNIX timestamp that the stream was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the Kinesis Stream.
 * @property openShards List of shard ids in the OPEN state. See [Shard State](https://docs.aws.amazon.com/streams/latest/dev/kinesis-using-sdk-java-after-resharding.html#kinesis-using-sdk-java-resharding-data-routing) for more.
 * @property retentionPeriod Length of time (in hours) data records are accessible after they are added to the stream.
 * @property shardLevelMetrics List of shard-level CloudWatch metrics which are enabled for the stream. See [Monitoring with CloudWatch](https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html) for more.
 * @property status Current status of the stream. The stream status is one of CREATING, DELETING, ACTIVE, or UPDATING.
 * @property streamModeDetails [Capacity mode](https://docs.aws.amazon.com/streams/latest/dev/how-do-i-size-a-stream.html) of the data stream. Detailed below.
 * @property tags Map of tags to assigned to the stream.
 */
public data class GetStreamResult(
    public val arn: String,
    public val closedShards: List<String>,
    public val creationTimestamp: Int,
    public val id: String,
    public val name: String,
    public val openShards: List<String>,
    public val retentionPeriod: Int,
    public val shardLevelMetrics: List<String>,
    public val status: String,
    public val streamModeDetails: List<GetStreamStreamModeDetail>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesis.outputs.GetStreamResult): GetStreamResult =
            GetStreamResult(
                arn = javaType.arn(),
                closedShards = javaType.closedShards().map({ args0 -> args0 }),
                creationTimestamp = javaType.creationTimestamp(),
                id = javaType.id(),
                name = javaType.name(),
                openShards = javaType.openShards().map({ args0 -> args0 }),
                retentionPeriod = javaType.retentionPeriod(),
                shardLevelMetrics = javaType.shardLevelMetrics().map({ args0 -> args0 }),
                status = javaType.status(),
                streamModeDetails = javaType.streamModeDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesis.kotlin.outputs.GetStreamStreamModeDetail.Companion.toKotlin(args0)
                    })
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
