@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin

import com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Kinesis Analytics v2 Application Snapshot.
 * Snapshots are the AWS implementation of [Flink Savepoints](https://ci.apache.org/projects/flink/flink-docs-release-1.11/ops/state/savepoints.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kinesisanalyticsv2.ApplicationSnapshot("example", {
 *     applicationName: exampleAwsKinesisanalyticsv2Application.name,
 *     snapshotName: "example-snapshot",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kinesisanalyticsv2.ApplicationSnapshot("example",
 *     application_name=example_aws_kinesisanalyticsv2_application["name"],
 *     snapshot_name="example-snapshot")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.KinesisAnalyticsV2.ApplicationSnapshot("example", new()
 *     {
 *         ApplicationName = exampleAwsKinesisanalyticsv2Application.Name,
 *         SnapshotName = "example-snapshot",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kinesisanalyticsv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kinesisanalyticsv2.NewApplicationSnapshot(ctx, "example", &kinesisanalyticsv2.ApplicationSnapshotArgs{
 * 			ApplicationName: pulumi.Any(exampleAwsKinesisanalyticsv2Application.Name),
 * 			SnapshotName:    pulumi.String("example-snapshot"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshot;
 * import com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationSnapshot("example", ApplicationSnapshotArgs.builder()
 *             .applicationName(exampleAwsKinesisanalyticsv2Application.name())
 *             .snapshotName("example-snapshot")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kinesisanalyticsv2:ApplicationSnapshot
 *     properties:
 *       applicationName: ${exampleAwsKinesisanalyticsv2Application.name}
 *       snapshotName: example-snapshot
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_kinesisanalyticsv2_application` using `application_name` together with `snapshot_name`. For example:
 * ```sh
 * $ pulumi import aws:kinesisanalyticsv2/applicationSnapshot:ApplicationSnapshot example example-application/example-snapshot
 * ```
 * @property applicationName The name of an existing  Kinesis Analytics v2 Application. Note that the application must be running for a snapshot to be created.
 * @property snapshotName The name of the application snapshot.
 */
public data class ApplicationSnapshotArgs(
    public val applicationName: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs =
        com.pulumi.aws.kinesisanalyticsv2.ApplicationSnapshotArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationSnapshotArgs].
 */
@PulumiTagMarker
public class ApplicationSnapshotArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var snapshotName: Output<String>? = null

    /**
     * @param value The name of an existing  Kinesis Analytics v2 Application. Note that the application must be running for a snapshot to be created.
     */
    @JvmName("cclquacimcjcmaef")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the application snapshot.
     */
    @JvmName("yupukftkwtccldna")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value The name of an existing  Kinesis Analytics v2 Application. Note that the application must be running for a snapshot to be created.
     */
    @JvmName("qwpuwtepwdevroje")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the application snapshot.
     */
    @JvmName("gqljutiabexbabby")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    internal fun build(): ApplicationSnapshotArgs = ApplicationSnapshotArgs(
        applicationName = applicationName,
        snapshotName = snapshotName,
    )
}
