@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codeContent The location and type of the application code.
 * @property codeContentType Specifies whether the code content is in text or zip format. Valid values: `PLAINTEXT`, `ZIPFILE`.
 */
public data class ApplicationApplicationConfigurationApplicationCodeConfigurationArgs(
    public val codeContent: Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs>? =
        null,
    public val codeContentType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationApplicationCodeConfigurationArgs.builder()
            .codeContent(codeContent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .codeContentType(codeContentType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationApplicationCodeConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationApplicationCodeConfigurationArgsBuilder internal constructor() {
    private var codeContent:
        Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs>? = null

    private var codeContentType: Output<String>? = null

    /**
     * @param value The location and type of the application code.
     */
    @JvmName("bwhielxllkadyrdx")
    public suspend fun codeContent(`value`: Output<ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs>) {
        this.codeContent = value
    }

    /**
     * @param value Specifies whether the code content is in text or zip format. Valid values: `PLAINTEXT`, `ZIPFILE`.
     */
    @JvmName("hfluonclydbeuspj")
    public suspend fun codeContentType(`value`: Output<String>) {
        this.codeContentType = value
    }

    /**
     * @param value The location and type of the application code.
     */
    @JvmName("pujelrycwejlcenc")
    public suspend fun codeContent(`value`: ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeContent = mapped
    }

    /**
     * @param argument The location and type of the application code.
     */
    @JvmName("wkmikavpltcwefgb")
    public suspend fun codeContent(argument: suspend ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationApplicationCodeConfigurationCodeContentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.codeContent = mapped
    }

    /**
     * @param value Specifies whether the code content is in text or zip format. Valid values: `PLAINTEXT`, `ZIPFILE`.
     */
    @JvmName("ledamgkiytmsagdg")
    public suspend fun codeContentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.codeContentType = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationApplicationCodeConfigurationArgs =
        ApplicationApplicationConfigurationApplicationCodeConfigurationArgs(
            codeContent = codeContent,
            codeContentType = codeContentType ?: throw PulumiNullFieldException("codeContentType"),
        )
}
