@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property propertyGroupId The key of the application execution property key-value map.
 * @property propertyMap Application execution property key-value map.
 */
public data class ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs(
    public val propertyGroupId: Output<String>,
    public val propertyMap: Output<Map<String, String>>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs.builder()
            .propertyGroupId(propertyGroupId.applyValue({ args0 -> args0 }))
            .propertyMap(
                propertyMap.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgsBuilder
internal constructor() {
    private var propertyGroupId: Output<String>? = null

    private var propertyMap: Output<Map<String, String>>? = null

    /**
     * @param value The key of the application execution property key-value map.
     */
    @JvmName("ibfdoboocqhjvlos")
    public suspend fun propertyGroupId(`value`: Output<String>) {
        this.propertyGroupId = value
    }

    /**
     * @param value Application execution property key-value map.
     */
    @JvmName("qrxnuccdbumcrhib")
    public suspend fun propertyMap(`value`: Output<Map<String, String>>) {
        this.propertyMap = value
    }

    /**
     * @param value The key of the application execution property key-value map.
     */
    @JvmName("jdcnsmovwxoqihif")
    public suspend fun propertyGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyGroupId = mapped
    }

    /**
     * @param value Application execution property key-value map.
     */
    @JvmName("ukjhxuuxbjjvpime")
    public suspend fun propertyMap(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyMap = mapped
    }

    /**
     * @param values Application execution property key-value map.
     */
    @JvmName("sglombwblkjtpmga")
    public fun propertyMap(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyMap = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs =
        ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroupArgs(
            propertyGroupId = propertyGroupId ?: throw PulumiNullFieldException("propertyGroupId"),
            propertyMap = propertyMap ?: throw PulumiNullFieldException("propertyMap"),
        )
}
