@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property checkpointConfiguration Describes an application's checkpointing configuration.
 * @property monitoringConfiguration Describes configuration parameters for CloudWatch logging for an application.
 * @property parallelismConfiguration Describes parameters for how an application executes multiple tasks simultaneously.
 */
public data class ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs(
    public val checkpointConfiguration: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs>? =
        null,
    public val monitoringConfiguration: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs>? =
        null,
    public val parallelismConfiguration: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs.builder()
            .checkpointConfiguration(
                checkpointConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .monitoringConfiguration(
                monitoringConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .parallelismConfiguration(
                parallelismConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationFlinkApplicationConfigurationArgsBuilder internal constructor() {
    private var checkpointConfiguration:
        Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs>? =
        null

    private var monitoringConfiguration:
        Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs>? =
        null

    private var parallelismConfiguration:
        Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs>? =
        null

    /**
     * @param value Describes an application's checkpointing configuration.
     */
    @JvmName("ynnfwrojlptvmqhj")
    public suspend fun checkpointConfiguration(`value`: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs>) {
        this.checkpointConfiguration = value
    }

    /**
     * @param value Describes configuration parameters for CloudWatch logging for an application.
     */
    @JvmName("hhpknmeokunofesn")
    public suspend fun monitoringConfiguration(`value`: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs>) {
        this.monitoringConfiguration = value
    }

    /**
     * @param value Describes parameters for how an application executes multiple tasks simultaneously.
     */
    @JvmName("gqunuwkuolvlcqdg")
    public suspend fun parallelismConfiguration(`value`: Output<ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs>) {
        this.parallelismConfiguration = value
    }

    /**
     * @param value Describes an application's checkpointing configuration.
     */
    @JvmName("oxrfombjgcivnauf")
    public suspend fun checkpointConfiguration(`value`: ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointConfiguration = mapped
    }

    /**
     * @param argument Describes an application's checkpointing configuration.
     */
    @JvmName("aupnbliyjaoklnpa")
    public suspend fun checkpointConfiguration(argument: suspend ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.checkpointConfiguration = mapped
    }

    /**
     * @param value Describes configuration parameters for CloudWatch logging for an application.
     */
    @JvmName("haomosmcnuidqagx")
    public suspend fun monitoringConfiguration(`value`: ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringConfiguration = mapped
    }

    /**
     * @param argument Describes configuration parameters for CloudWatch logging for an application.
     */
    @JvmName("anmaxgrcclkursgf")
    public suspend fun monitoringConfiguration(argument: suspend ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.monitoringConfiguration = mapped
    }

    /**
     * @param value Describes parameters for how an application executes multiple tasks simultaneously.
     */
    @JvmName("avcopmubawlfkvpn")
    public suspend fun parallelismConfiguration(`value`: ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelismConfiguration = mapped
    }

    /**
     * @param argument Describes parameters for how an application executes multiple tasks simultaneously.
     */
    @JvmName("wmscucobtholseob")
    public suspend fun parallelismConfiguration(argument: suspend ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.parallelismConfiguration = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs =
        ApplicationApplicationConfigurationFlinkApplicationConfigurationArgs(
            checkpointConfiguration = checkpointConfiguration,
            monitoringConfiguration = monitoringConfiguration,
            parallelismConfiguration = parallelismConfiguration,
        )
}
