@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property checkpointInterval Describes the interval in milliseconds between checkpoint operations.
 * @property checkpointingEnabled Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
 * @property configurationType Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `checkpointing_enabled`, `checkpoint_interval`, or `min_pause_between_checkpoints` attribute values to be effective. If this attribute is set to `DEFAULT`, the application will always use the following values:
 * * `checkpointing_enabled = true`
 * * `checkpoint_interval = 60000`
 * * `min_pause_between_checkpoints = 5000`
 * @property minPauseBetweenCheckpoints Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs(
    public val checkpointInterval: Output<Int>? = null,
    public val checkpointingEnabled: Output<Boolean>? = null,
    public val configurationType: Output<String>,
    public val minPauseBetweenCheckpoints: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs.builder()
            .checkpointInterval(checkpointInterval?.applyValue({ args0 -> args0 }))
            .checkpointingEnabled(checkpointingEnabled?.applyValue({ args0 -> args0 }))
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .minPauseBetweenCheckpoints(minPauseBetweenCheckpoints?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgsBuilder
internal constructor() {
    private var checkpointInterval: Output<Int>? = null

    private var checkpointingEnabled: Output<Boolean>? = null

    private var configurationType: Output<String>? = null

    private var minPauseBetweenCheckpoints: Output<Int>? = null

    /**
     * @param value Describes the interval in milliseconds between checkpoint operations.
     */
    @JvmName("upcmwmuwpnoniywn")
    public suspend fun checkpointInterval(`value`: Output<Int>) {
        this.checkpointInterval = value
    }

    /**
     * @param value Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("ocdxcbesybwqkiwp")
    public suspend fun checkpointingEnabled(`value`: Output<Boolean>) {
        this.checkpointingEnabled = value
    }

    /**
     * @param value Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `checkpointing_enabled`, `checkpoint_interval`, or `min_pause_between_checkpoints` attribute values to be effective. If this attribute is set to `DEFAULT`, the application will always use the following values:
     * * `checkpointing_enabled = true`
     * * `checkpoint_interval = 60000`
     * * `min_pause_between_checkpoints = 5000`
     */
    @JvmName("ktptnceqdpnrdcnt")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
     */
    @JvmName("gecdeqxwflhdmqgg")
    public suspend fun minPauseBetweenCheckpoints(`value`: Output<Int>) {
        this.minPauseBetweenCheckpoints = value
    }

    /**
     * @param value Describes the interval in milliseconds between checkpoint operations.
     */
    @JvmName("fujydmbnrorusomn")
    public suspend fun checkpointInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointInterval = mapped
    }

    /**
     * @param value Describes whether checkpointing is enabled for a Flink-based Kinesis Data Analytics application.
     */
    @JvmName("fnwqvijflgnylayr")
    public suspend fun checkpointingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkpointingEnabled = mapped
    }

    /**
     * @param value Describes whether the application uses Kinesis Data Analytics' default checkpointing behavior. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `checkpointing_enabled`, `checkpoint_interval`, or `min_pause_between_checkpoints` attribute values to be effective. If this attribute is set to `DEFAULT`, the application will always use the following values:
     * * `checkpointing_enabled = true`
     * * `checkpoint_interval = 60000`
     * * `min_pause_between_checkpoints = 5000`
     */
    @JvmName("ipmrbbmtemnskhcw")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Describes the minimum time in milliseconds after a checkpoint operation completes that a new checkpoint operation can start.
     */
    @JvmName("pbleyngfrjcxoqdp")
    public suspend fun minPauseBetweenCheckpoints(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minPauseBetweenCheckpoints = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs =
        ApplicationApplicationConfigurationFlinkApplicationConfigurationCheckpointConfigurationArgs(
            checkpointInterval = checkpointInterval,
            checkpointingEnabled = checkpointingEnabled,
            configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
            minPauseBetweenCheckpoints = minPauseBetweenCheckpoints,
        )
}
