@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationType Describes whether to use the default CloudWatch logging configuration for an application. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `log_level` or `metrics_level` attribute values to be effective.
 * @property logLevel Describes the verbosity of the CloudWatch Logs for an application. Valid values: `DEBUG`, `ERROR`, `INFO`, `WARN`.
 * @property metricsLevel Describes the granularity of the CloudWatch Logs for an application. Valid values: `APPLICATION`, `OPERATOR`, `PARALLELISM`, `TASK`.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs(
    public val configurationType: Output<String>,
    public val logLevel: Output<String>? = null,
    public val metricsLevel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs.builder()
            .configurationType(configurationType.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .metricsLevel(metricsLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgsBuilder
internal constructor() {
    private var configurationType: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var metricsLevel: Output<String>? = null

    /**
     * @param value Describes whether to use the default CloudWatch logging configuration for an application. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `log_level` or `metrics_level` attribute values to be effective.
     */
    @JvmName("jttvcnmfthmikfmx")
    public suspend fun configurationType(`value`: Output<String>) {
        this.configurationType = value
    }

    /**
     * @param value Describes the verbosity of the CloudWatch Logs for an application. Valid values: `DEBUG`, `ERROR`, `INFO`, `WARN`.
     */
    @JvmName("ralkkvvtuuflyslo")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Describes the granularity of the CloudWatch Logs for an application. Valid values: `APPLICATION`, `OPERATOR`, `PARALLELISM`, `TASK`.
     */
    @JvmName("fgahtxirjmbyasld")
    public suspend fun metricsLevel(`value`: Output<String>) {
        this.metricsLevel = value
    }

    /**
     * @param value Describes whether to use the default CloudWatch logging configuration for an application. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `log_level` or `metrics_level` attribute values to be effective.
     */
    @JvmName("torbebgcmcwsgvgp")
    public suspend fun configurationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationType = mapped
    }

    /**
     * @param value Describes the verbosity of the CloudWatch Logs for an application. Valid values: `DEBUG`, `ERROR`, `INFO`, `WARN`.
     */
    @JvmName("otermjfwnlmkejss")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Describes the granularity of the CloudWatch Logs for an application. Valid values: `APPLICATION`, `OPERATOR`, `PARALLELISM`, `TASK`.
     */
    @JvmName("hokpsjffirugxift")
    public suspend fun metricsLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsLevel = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs =
        ApplicationApplicationConfigurationFlinkApplicationConfigurationMonitoringConfigurationArgs(
            configurationType = configurationType ?: throw PulumiNullFieldException("configurationType"),
            logLevel = logLevel,
            metricsLevel = metricsLevel,
        )
}
