@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowNonRestoredState When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be mapped to the new program. Default is `false`.
 */
public data class ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs(
    public val allowNonRestoredState: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs.builder()
            .allowNonRestoredState(allowNonRestoredState?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgsBuilder
internal constructor() {
    private var allowNonRestoredState: Output<Boolean>? = null

    /**
     * @param value When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be mapped to the new program. Default is `false`.
     */
    @JvmName("puunycdlfbwgkssi")
    public suspend fun allowNonRestoredState(`value`: Output<Boolean>) {
        this.allowNonRestoredState = value
    }

    /**
     * @param value When restoring from a snapshot, specifies whether the runtime is allowed to skip a state that cannot be mapped to the new program. Default is `false`.
     */
    @JvmName("rqemrqctjcfxqdca")
    public suspend fun allowNonRestoredState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowNonRestoredState = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs = ApplicationApplicationConfigurationRunConfigurationFlinkRunConfigurationArgs(
        allowNonRestoredState = allowNonRestoredState,
    )
}
