@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property csvMappingParameters Provides additional mapping information when the record format uses delimiters (for example, CSV).
 * @property jsonMappingParameters Provides additional mapping information when JSON is the record format on the streaming source.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs(
    public val csvMappingParameters: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs>? =
        null,
    public val jsonMappingParameters: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs.builder()
            .csvMappingParameters(
                csvMappingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .jsonMappingParameters(
                jsonMappingParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgsBuilder
internal constructor() {
    private var csvMappingParameters:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs>? =
        null

    private var jsonMappingParameters:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgs>? =
        null

    /**
     * @param value Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("xwgpfxmbekbgtajw")
    public suspend fun csvMappingParameters(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs>) {
        this.csvMappingParameters = value
    }

    /**
     * @param value Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("jqmssrppbapdycyb")
    public suspend fun jsonMappingParameters(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgs>) {
        this.jsonMappingParameters = value
    }

    /**
     * @param value Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("wjxtdhacubedljgj")
    public suspend fun csvMappingParameters(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvMappingParameters = mapped
    }

    /**
     * @param argument Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    @JvmName("fvoukpryfcwupikc")
    public suspend fun csvMappingParameters(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersCsvMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.csvMappingParameters = mapped
    }

    /**
     * @param value Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("lqhjixfpovtobchu")
    public suspend fun jsonMappingParameters(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonMappingParameters = mapped
    }

    /**
     * @param argument Provides additional mapping information when JSON is the record format on the streaming source.
     */
    @JvmName("yjgmwtfsirexqbxk")
    public suspend fun jsonMappingParameters(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersJsonMappingParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonMappingParameters = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationInputInputSchemaRecordFormatMappingParametersArgs(
            csvMappingParameters = csvMappingParameters,
            jsonMappingParameters = jsonMappingParameters,
        )
}
