@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property recordColumns Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
 * @property recordEncoding Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
 * @property recordFormat Specifies the format of the records on the streaming source.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs(
    public val recordColumns: Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>>,
    public val recordEncoding: Output<String>? = null,
    public val recordFormat: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs.builder()
            .recordColumns(
                recordColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .recordEncoding(recordEncoding?.applyValue({ args0 -> args0 }))
            .recordFormat(recordFormat.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgsBuilder
internal constructor() {
    private var recordColumns:
        Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>>? =
        null

    private var recordEncoding: Output<String>? = null

    private var recordFormat:
        Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs>? =
        null

    /**
     * @param value Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("ryjcpbltcafaqsvf")
    public suspend fun recordColumns(`value`: Output<List<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>>) {
        this.recordColumns = value
    }

    @JvmName("jlewomrrtfumhvfa")
    public suspend fun recordColumns(vararg values: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>) {
        this.recordColumns = Output.all(values.asList())
    }

    /**
     * @param values Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("gcnsuwfqhsncxlca")
    public suspend fun recordColumns(values: List<Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>>) {
        this.recordColumns = Output.all(values)
    }

    /**
     * @param value Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
     */
    @JvmName("iaserpjanvdedqdy")
    public suspend fun recordEncoding(`value`: Output<String>) {
        this.recordEncoding = value
    }

    /**
     * @param value Specifies the format of the records on the streaming source.
     */
    @JvmName("evyfcvjinegeiihv")
    public suspend fun recordFormat(`value`: Output<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs>) {
        this.recordFormat = value
    }

    /**
     * @param value Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("rabaouajwrdofrnp")
    public suspend fun recordColumns(`value`: List<ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("sewibqktvgufvnkl")
    public suspend fun recordColumns(argument: List<suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("tgcnubrdydgxmkot")
    public suspend fun recordColumns(vararg argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param argument Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("gdkuugusiqbdxdyn")
    public suspend fun recordColumns(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.recordColumns = mapped
    }

    /**
     * @param values Describes the mapping of each data element in the streaming source to the corresponding column in the in-application stream.
     */
    @JvmName("mlncifrvdvryunay")
    public suspend fun recordColumns(vararg values: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordColumns = mapped
    }

    /**
     * @param value Specifies the encoding of the records in the streaming source. For example, `UTF-8`.
     */
    @JvmName("cagsfppuxxtfvmqd")
    public suspend fun recordEncoding(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordEncoding = mapped
    }

    /**
     * @param value Specifies the format of the records on the streaming source.
     */
    @JvmName("tnyxovqnlecgmysf")
    public suspend fun recordFormat(`value`: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recordFormat = mapped
    }

    /**
     * @param argument Specifies the format of the records on the streaming source.
     */
    @JvmName("laubjwfnotpnftuo")
    public suspend fun recordFormat(argument: suspend ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgsBuilder.() -> Unit) {
        val toBeMapped =
            ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordFormatArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.recordFormat = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaArgs(
            recordColumns = recordColumns ?: throw PulumiNullFieldException("recordColumns"),
            recordEncoding = recordEncoding,
            recordFormat = recordFormat ?: throw PulumiNullFieldException("recordFormat"),
        )
}
