@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mapping A reference to the data element in the streaming input or the reference data source.
 * @property name The name of the column that is created in the in-application input stream or reference table.
 * @property sqlType The type of column created in the in-application input stream or reference table.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs(
    public val mapping: Output<String>? = null,
    public val name: Output<String>,
    public val sqlType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs.builder()
            .mapping(mapping?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .sqlType(sqlType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgsBuilder
internal constructor() {
    private var mapping: Output<String>? = null

    private var name: Output<String>? = null

    private var sqlType: Output<String>? = null

    /**
     * @param value A reference to the data element in the streaming input or the reference data source.
     */
    @JvmName("dkrpciftukyyeqnp")
    public suspend fun mapping(`value`: Output<String>) {
        this.mapping = value
    }

    /**
     * @param value The name of the column that is created in the in-application input stream or reference table.
     */
    @JvmName("tgvhvxudpjmmachr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of column created in the in-application input stream or reference table.
     */
    @JvmName("ilqedmftdowaqgwa")
    public suspend fun sqlType(`value`: Output<String>) {
        this.sqlType = value
    }

    /**
     * @param value A reference to the data element in the streaming input or the reference data source.
     */
    @JvmName("dmbvdinjiqekhpkn")
    public suspend fun mapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapping = mapped
    }

    /**
     * @param value The name of the column that is created in the in-application input stream or reference table.
     */
    @JvmName("usnullkkfogjwtee")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of column created in the in-application input stream or reference table.
     */
    @JvmName("tatalmfhfrawnjbu")
    public suspend fun sqlType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlType = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceReferenceSchemaRecordColumnArgs(
            mapping = mapping,
            name = name ?: throw PulumiNullFieldException("name"),
            sqlType = sqlType ?: throw PulumiNullFieldException("sqlType"),
        )
}
