@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.inputs

import com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketArn The ARN of the S3 bucket.
 * @property fileKey The object key name containing the reference data.
 */
public data class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs(
    public val bucketArn: Output<String>,
    public val fileKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs> {
    override fun toJava(): com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs =
        com.pulumi.aws.kinesisanalyticsv2.inputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs.builder()
            .bucketArn(bucketArn.applyValue({ args0 -> args0 }))
            .fileKey(fileKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs].
 */
@PulumiTagMarker
public class
ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgsBuilder
internal constructor() {
    private var bucketArn: Output<String>? = null

    private var fileKey: Output<String>? = null

    /**
     * @param value The ARN of the S3 bucket.
     */
    @JvmName("jhyqopxkrcbrbluk")
    public suspend fun bucketArn(`value`: Output<String>) {
        this.bucketArn = value
    }

    /**
     * @param value The object key name containing the reference data.
     */
    @JvmName("eebdaywipaxsefxr")
    public suspend fun fileKey(`value`: Output<String>) {
        this.fileKey = value
    }

    /**
     * @param value The ARN of the S3 bucket.
     */
    @JvmName("akherpwxltpwyoqh")
    public suspend fun bucketArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketArn = mapped
    }

    /**
     * @param value The object key name containing the reference data.
     */
    @JvmName("weeldmqpkhjpyfjs")
    public suspend fun fileKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileKey = mapped
    }

    internal fun build(): ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs =
        ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSourceS3ReferenceDataSourceArgs(
            bucketArn = bucketArn ?: throw PulumiNullFieldException("bucketArn"),
            fileKey = fileKey ?: throw PulumiNullFieldException("fileKey"),
        )
}
