@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property applicationCodeConfiguration The code location and type parameters for the application.
 * @property applicationSnapshotConfiguration Describes whether snapshots are enabled for a Flink-based application.
 * @property environmentProperties Describes execution properties for a Flink-based application.
 * @property flinkApplicationConfiguration The configuration of a Flink-based application.
 * @property runConfiguration Describes the starting properties for a Flink-based application.
 * @property sqlApplicationConfiguration The configuration of a SQL-based application.
 * @property vpcConfiguration The VPC configuration of a Flink-based application.
 */
public data class ApplicationApplicationConfiguration(
    public val applicationCodeConfiguration: ApplicationApplicationConfigurationApplicationCodeConfiguration,
    public val applicationSnapshotConfiguration: ApplicationApplicationConfigurationApplicationSnapshotConfiguration? = null,
    public val environmentProperties: ApplicationApplicationConfigurationEnvironmentProperties? =
        null,
    public val flinkApplicationConfiguration: ApplicationApplicationConfigurationFlinkApplicationConfiguration? = null,
    public val runConfiguration: ApplicationApplicationConfigurationRunConfiguration? = null,
    public val sqlApplicationConfiguration: ApplicationApplicationConfigurationSqlApplicationConfiguration? = null,
    public val vpcConfiguration: ApplicationApplicationConfigurationVpcConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfiguration): ApplicationApplicationConfiguration = ApplicationApplicationConfiguration(
            applicationCodeConfiguration = javaType.applicationCodeConfiguration().let({ args0 ->
                com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationApplicationCodeConfiguration.Companion.toKotlin(args0)
            }),
            applicationSnapshotConfiguration = javaType.applicationSnapshotConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationApplicationSnapshotConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentProperties = javaType.environmentProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationEnvironmentProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            flinkApplicationConfiguration = javaType.flinkApplicationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationFlinkApplicationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runConfiguration = javaType.runConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationRunConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sqlApplicationConfiguration = javaType.sqlApplicationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpcConfiguration = javaType.vpcConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationVpcConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
