@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property propertyGroupId The key of the application execution property key-value map.
 * @property propertyMap Application execution property key-value map.
 */
public data class ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroup(
    public val propertyGroupId: String,
    public val propertyMap: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroup): ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroup =
            ApplicationApplicationConfigurationEnvironmentPropertiesPropertyGroup(
                propertyGroupId = javaType.propertyGroupId(),
                propertyMap = javaType.propertyMap().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
