@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoScalingEnabled Describes whether the Kinesis Data Analytics service can increase the parallelism of the application in response to increased throughput.
 * @property configurationType Describes whether the application uses the default parallelism for the Kinesis Data Analytics service. Valid values: `CUSTOM`, `DEFAULT`. Set this attribute to `CUSTOM` in order for any specified `auto_scaling_enabled`, `parallelism`, or `parallelism_per_kpu` attribute values to be effective.
 * @property parallelism Describes the initial number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform.
 * @property parallelismPerKpu Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics application can perform per Kinesis Processing Unit (KPU) used by the application.
 */
public data class
ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration(
    public val autoScalingEnabled: Boolean? = null,
    public val configurationType: String,
    public val parallelism: Int? = null,
    public val parallelismPerKpu: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration): ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration =
            ApplicationApplicationConfigurationFlinkApplicationConfigurationParallelismConfiguration(
                autoScalingEnabled = javaType.autoScalingEnabled().map({ args0 -> args0 }).orElse(null),
                configurationType = javaType.configurationType(),
                parallelism = javaType.parallelism().map({ args0 -> args0 }).orElse(null),
                parallelismPerKpu = javaType.parallelismPerKpu().map({ args0 -> args0 }).orElse(null),
            )
    }
}
