@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property applicationRestoreConfiguration The restore behavior of a restarting application.
 * @property flinkRunConfiguration The starting parameters for a Flink-based Kinesis Data Analytics application.
 */
public data class ApplicationApplicationConfigurationRunConfiguration(
    public val applicationRestoreConfiguration: ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration? = null,
    public val flinkRunConfiguration: ApplicationApplicationConfigurationRunConfigurationFlinkRunConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationRunConfiguration): ApplicationApplicationConfigurationRunConfiguration =
            ApplicationApplicationConfigurationRunConfiguration(
                applicationRestoreConfiguration = javaType.applicationRestoreConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationRunConfigurationApplicationRestoreConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                flinkRunConfiguration = javaType.flinkRunConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationRunConfigurationFlinkRunConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
