@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property input The input stream used by the application.
 * @property outputs The destination streams used by the application.
 * @property referenceDataSource The reference data source used by the application.
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfiguration(
    public val input: ApplicationApplicationConfigurationSqlApplicationConfigurationInput? = null,
    public val outputs: List<ApplicationApplicationConfigurationSqlApplicationConfigurationOutput>? =
        null,
    public val referenceDataSource: ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationSqlApplicationConfiguration): ApplicationApplicationConfigurationSqlApplicationConfiguration =
            ApplicationApplicationConfigurationSqlApplicationConfiguration(
                input = javaType.input().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationInput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                outputs = javaType.outputs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutput.Companion.toKotlin(args0)
                    })
                }),
                referenceDataSource = javaType.referenceDataSource().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationReferenceDataSource.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
