@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationSchema Describes the data format when records are written to the destination.
 * @property kinesisFirehoseOutput Identifies a Kinesis Data Firehose delivery stream as the destination.
 * @property kinesisStreamsOutput Identifies a Kinesis data stream as the destination.
 * @property lambdaOutput Identifies a Lambda function as the destination.
 * @property name The name of the in-application stream.
 * @property outputId
 */
public data class ApplicationApplicationConfigurationSqlApplicationConfigurationOutput(
    public val destinationSchema: ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchema,
    public val kinesisFirehoseOutput: ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisFirehoseOutput? =
        null,
    public val kinesisStreamsOutput: ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisStreamsOutput? =
        null,
    public val lambdaOutput: ApplicationApplicationConfigurationSqlApplicationConfigurationOutputLambdaOutput? = null,
    public val name: String,
    public val outputId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutput): ApplicationApplicationConfigurationSqlApplicationConfigurationOutput =
            ApplicationApplicationConfigurationSqlApplicationConfigurationOutput(
                destinationSchema = javaType.destinationSchema().let({ args0 ->
                    com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutputDestinationSchema.Companion.toKotlin(args0)
                }),
                kinesisFirehoseOutput = javaType.kinesisFirehoseOutput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisFirehoseOutput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                kinesisStreamsOutput = javaType.kinesisStreamsOutput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutputKinesisStreamsOutput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lambdaOutput = javaType.lambdaOutput().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs.ApplicationApplicationConfigurationSqlApplicationConfigurationOutputLambdaOutput.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name(),
                outputId = javaType.outputId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
