@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kinesisanalyticsv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds The Security Group IDs used by the VPC configuration.
 * @property subnetIds The Subnet IDs used by the VPC configuration.
 * @property vpcConfigurationId
 * @property vpcId
 */
public data class ApplicationApplicationConfigurationVpcConfiguration(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcConfigurationId: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kinesisanalyticsv2.outputs.ApplicationApplicationConfigurationVpcConfiguration): ApplicationApplicationConfigurationVpcConfiguration =
            ApplicationApplicationConfigurationVpcConfiguration(
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
                vpcConfigurationId = javaType.vpcConfigurationId().map({ args0 -> args0 }).orElse(null),
                vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
