@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.CiphertextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The KMS ciphertext resource allows you to encrypt plaintext into ciphertext
 * by using an AWS KMS customer master key. The value returned by this resource
 * is stable across every apply. For a changing ciphertext value each apply, see
 * the `aws.kms.Ciphertext` data source.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const oauthConfig = new aws.kms.Key("oauth_config", {
 *     description: "oauth config",
 *     isEnabled: true,
 * });
 * const oauth = new aws.kms.Ciphertext("oauth", {
 *     keyId: oauthConfig.keyId,
 *     plaintext: `{
 *   "client_id": "e587dbae22222f55da22",
 *   "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * oauth_config = aws.kms.Key("oauth_config",
 *     description="oauth config",
 *     is_enabled=True)
 * oauth = aws.kms.Ciphertext("oauth",
 *     key_id=oauth_config.key_id,
 *     plaintext="""{
 *   "client_id": "e587dbae22222f55da22",
 *   "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
 * }
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var oauthConfig = new Aws.Kms.Key("oauth_config", new()
 *     {
 *         Description = "oauth config",
 *         IsEnabled = true,
 *     });
 *     var oauth = new Aws.Kms.Ciphertext("oauth", new()
 *     {
 *         KeyId = oauthConfig.KeyId,
 *         Plaintext = @"{
 *   ""client_id"": ""e587dbae22222f55da22"",
 *   ""client_secret"": ""8289575d00000ace55e1815ec13673955721b8a5""
 * }
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		oauthConfig, err := kms.NewKey(ctx, "oauth_config", &kms.KeyArgs{
 * 			Description: pulumi.String("oauth config"),
 * 			IsEnabled:   pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewCiphertext(ctx, "oauth", &kms.CiphertextArgs{
 * 			KeyId:     oauthConfig.KeyId,
 * 			Plaintext: pulumi.String("{\n  \"client_id\": \"e587dbae22222f55da22\",\n  \"client_secret\": \"8289575d00000ace55e1815ec13673955721b8a5\"\n}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.Ciphertext;
 * import com.pulumi.aws.kms.CiphertextArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oauthConfig = new Key("oauthConfig", KeyArgs.builder()
 *             .description("oauth config")
 *             .isEnabled(true)
 *             .build());
 *         var oauth = new Ciphertext("oauth", CiphertextArgs.builder()
 *             .keyId(oauthConfig.keyId())
 *             .plaintext("""
 * {
 *   "client_id": "e587dbae22222f55da22",
 *   "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
 * }
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   oauthConfig:
 *     type: aws:kms:Key
 *     name: oauth_config
 *     properties:
 *       description: oauth config
 *       isEnabled: true
 *   oauth:
 *     type: aws:kms:Ciphertext
 *     properties:
 *       keyId: ${oauthConfig.keyId}
 *       plaintext: |
 *         {
 *           "client_id": "e587dbae22222f55da22",
 *           "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * @property context An optional mapping that makes up the encryption context.
 * @property keyId Globally unique key ID for the customer master key.
 * @property plaintext Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
 */
public data class CiphertextArgs(
    public val context: Output<Map<String, String>>? = null,
    public val keyId: Output<String>? = null,
    public val plaintext: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.CiphertextArgs> {
    override fun toJava(): com.pulumi.aws.kms.CiphertextArgs =
        com.pulumi.aws.kms.CiphertextArgs.builder()
            .context(context?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .plaintext(plaintext?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CiphertextArgs].
 */
@PulumiTagMarker
public class CiphertextArgsBuilder internal constructor() {
    private var context: Output<Map<String, String>>? = null

    private var keyId: Output<String>? = null

    private var plaintext: Output<String>? = null

    /**
     * @param value An optional mapping that makes up the encryption context.
     */
    @JvmName("guathvceifscmmau")
    public suspend fun context(`value`: Output<Map<String, String>>) {
        this.context = value
    }

    /**
     * @param value Globally unique key ID for the customer master key.
     */
    @JvmName("ijnnprpncqgxhejx")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
     */
    @JvmName("wefkmjwqpdeyrpho")
    public suspend fun plaintext(`value`: Output<String>) {
        this.plaintext = value
    }

    /**
     * @param value An optional mapping that makes up the encryption context.
     */
    @JvmName("uplblgddplpfsgki")
    public suspend fun context(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param values An optional mapping that makes up the encryption context.
     */
    @JvmName("jjfuhuvhmncrqfys")
    public fun context(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Globally unique key ID for the customer master key.
     */
    @JvmName("idvddemcavgfcnnf")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
     */
    @JvmName("udgmmmaddywudlqm")
    public suspend fun plaintext(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plaintext = mapped
    }

    internal fun build(): CiphertextArgs = CiphertextArgs(
        context = context,
        keyId = keyId,
        plaintext = plaintext,
    )
}
