@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.CustomKeyStoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS KMS (Key Management) Custom Key Store.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const test = new aws.kms.CustomKeyStore("test", {
 *     cloudHsmClusterId: cloudHsmClusterId,
 *     customKeyStoreName: "kms-custom-key-store-test",
 *     keyStorePassword: "noplaintextpasswords1",
 *     trustAnchorCertificate: std.file({
 *         input: "anchor-certificate.crt",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * test = aws.kms.CustomKeyStore("test",
 *     cloud_hsm_cluster_id=cloud_hsm_cluster_id,
 *     custom_key_store_name="kms-custom-key-store-test",
 *     key_store_password="noplaintextpasswords1",
 *     trust_anchor_certificate=std.file(input="anchor-certificate.crt").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Kms.CustomKeyStore("test", new()
 *     {
 *         CloudHsmClusterId = cloudHsmClusterId,
 *         CustomKeyStoreName = "kms-custom-key-store-test",
 *         KeyStorePassword = "noplaintextpasswords1",
 *         TrustAnchorCertificate = Std.File.Invoke(new()
 *         {
 *             Input = "anchor-certificate.crt",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "anchor-certificate.crt",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewCustomKeyStore(ctx, "test", &kms.CustomKeyStoreArgs{
 * 			CloudHsmClusterId:      pulumi.Any(cloudHsmClusterId),
 * 			CustomKeyStoreName:     pulumi.String("kms-custom-key-store-test"),
 * 			KeyStorePassword:       pulumi.String("noplaintextpasswords1"),
 * 			TrustAnchorCertificate: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.CustomKeyStore;
 * import com.pulumi.aws.kms.CustomKeyStoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new CustomKeyStore("test", CustomKeyStoreArgs.builder()
 *             .cloudHsmClusterId(cloudHsmClusterId)
 *             .customKeyStoreName("kms-custom-key-store-test")
 *             .keyStorePassword("noplaintextpasswords1")
 *             .trustAnchorCertificate(StdFunctions.file(FileArgs.builder()
 *                 .input("anchor-certificate.crt")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:kms:CustomKeyStore
 *     properties:
 *       cloudHsmClusterId: ${cloudHsmClusterId}
 *       customKeyStoreName: kms-custom-key-store-test
 *       keyStorePassword: noplaintextpasswords1
 *       trustAnchorCertificate:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: anchor-certificate.crt
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import KMS (Key Management) Custom Key Store using the `id`. For example:
 * ```sh
 * $ pulumi import aws:kms/customKeyStore:CustomKeyStore example cks-5ebd4ef395a96288e
 * ```
 * @property cloudHsmClusterId Cluster ID of CloudHSM.
 * @property customKeyStoreName Unique name for Custom Key Store.
 * @property keyStorePassword Password for `kmsuser` on CloudHSM.
 * @property trustAnchorCertificate Customer certificate used for signing on CloudHSM.
 */
public data class CustomKeyStoreArgs(
    public val cloudHsmClusterId: Output<String>? = null,
    public val customKeyStoreName: Output<String>? = null,
    public val keyStorePassword: Output<String>? = null,
    public val trustAnchorCertificate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.CustomKeyStoreArgs> {
    override fun toJava(): com.pulumi.aws.kms.CustomKeyStoreArgs =
        com.pulumi.aws.kms.CustomKeyStoreArgs.builder()
            .cloudHsmClusterId(cloudHsmClusterId?.applyValue({ args0 -> args0 }))
            .customKeyStoreName(customKeyStoreName?.applyValue({ args0 -> args0 }))
            .keyStorePassword(keyStorePassword?.applyValue({ args0 -> args0 }))
            .trustAnchorCertificate(trustAnchorCertificate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomKeyStoreArgs].
 */
@PulumiTagMarker
public class CustomKeyStoreArgsBuilder internal constructor() {
    private var cloudHsmClusterId: Output<String>? = null

    private var customKeyStoreName: Output<String>? = null

    private var keyStorePassword: Output<String>? = null

    private var trustAnchorCertificate: Output<String>? = null

    /**
     * @param value Cluster ID of CloudHSM.
     */
    @JvmName("fvrrngikajeganaw")
    public suspend fun cloudHsmClusterId(`value`: Output<String>) {
        this.cloudHsmClusterId = value
    }

    /**
     * @param value Unique name for Custom Key Store.
     */
    @JvmName("ppqhtxdsvshyxusi")
    public suspend fun customKeyStoreName(`value`: Output<String>) {
        this.customKeyStoreName = value
    }

    /**
     * @param value Password for `kmsuser` on CloudHSM.
     */
    @JvmName("mvlbkkxeoeaphugw")
    public suspend fun keyStorePassword(`value`: Output<String>) {
        this.keyStorePassword = value
    }

    /**
     * @param value Customer certificate used for signing on CloudHSM.
     */
    @JvmName("mhqdxdkxfupvqcvn")
    public suspend fun trustAnchorCertificate(`value`: Output<String>) {
        this.trustAnchorCertificate = value
    }

    /**
     * @param value Cluster ID of CloudHSM.
     */
    @JvmName("beswkytpvsydmxms")
    public suspend fun cloudHsmClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudHsmClusterId = mapped
    }

    /**
     * @param value Unique name for Custom Key Store.
     */
    @JvmName("ppuvgtkyhffeamcr")
    public suspend fun customKeyStoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeyStoreName = mapped
    }

    /**
     * @param value Password for `kmsuser` on CloudHSM.
     */
    @JvmName("fnsekebsenyxwhrs")
    public suspend fun keyStorePassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyStorePassword = mapped
    }

    /**
     * @param value Customer certificate used for signing on CloudHSM.
     */
    @JvmName("wyvfwpjfdglhsyuk")
    public suspend fun trustAnchorCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustAnchorCertificate = mapped
    }

    internal fun build(): CustomKeyStoreArgs = CustomKeyStoreArgs(
        cloudHsmClusterId = cloudHsmClusterId,
        customKeyStoreName = customKeyStoreName,
        keyStorePassword = keyStorePassword,
        trustAnchorCertificate = trustAnchorCertificate,
    )
}
