@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ExternalKey].
 */
@PulumiTagMarker
public class ExternalKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExternalKeyArgs = ExternalKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExternalKeyArgsBuilder.() -> Unit) {
        val builder = ExternalKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExternalKey {
        val builtJavaResource = com.pulumi.aws.kms.ExternalKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExternalKey(builtJavaResource)
    }
}

/**
 * Manages a single-Region or multi-Region primary KMS key that uses external key material.
 * To instead manage a single-Region or multi-Region primary KMS key where AWS automatically generates and potentially rotates key material, see the `aws.kms.Key` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.ExternalKey("example", {description: "KMS EXTERNAL for AMI encryption"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.ExternalKey("example", description="KMS EXTERNAL for AMI encryption")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.ExternalKey("example", new()
 *     {
 *         Description = "KMS EXTERNAL for AMI encryption",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kms.NewExternalKey(ctx, "example", &kms.ExternalKeyArgs{
 * 			Description: pulumi.String("KMS EXTERNAL for AMI encryption"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.ExternalKey;
 * import com.pulumi.aws.kms.ExternalKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExternalKey("example", ExternalKeyArgs.builder()
 *             .description("KMS EXTERNAL for AMI encryption")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:ExternalKey
 *     properties:
 *       description: KMS EXTERNAL for AMI encryption
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import KMS External Keys using the `id`. For example:
 * ```sh
 * $ pulumi import aws:kms/externalKey:ExternalKey a arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 */
public class ExternalKey internal constructor(
    override val javaResource: com.pulumi.aws.kms.ExternalKey,
) : KotlinCustomResource(javaResource, ExternalKeyMapper) {
    /**
     * The Amazon Resource Name (ARN) of the key.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to disable the policy lockout check performed when creating or updating the key's policy. Setting this value to `true` increases the risk that the key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the AWS Key Management Service Developer Guide. Defaults to `false`.
     */
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>?
        get() = javaResource.bypassPolicyLockoutSafetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Duration in days after which the key is deleted after destruction of the resource. Must be between `7` and `30` days. Defaults to `30`.
     */
    public val deletionWindowInDays: Output<Int>?
        get() = javaResource.deletionWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the key.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the key is enabled. Keys pending import can only be `false`. Imported keys default to `true` unless expired.
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * Whether the key material expires. Empty when pending key material import, otherwise `KEY_MATERIAL_EXPIRES` or `KEY_MATERIAL_DOES_NOT_EXPIRE`.
     */
    public val expirationModel: Output<String>
        get() = javaResource.expirationModel().applyValue({ args0 -> args0 })

    /**
     * Base64 encoded 256-bit symmetric encryption key material to import. The CMK is permanently associated with this key material. The same key material can be reimported, but you cannot import different key material.
     */
    public val keyMaterialBase64: Output<String>?
        get() = javaResource.keyMaterialBase64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the CMK.
     */
    public val keyState: Output<String>
        get() = javaResource.keyState().applyValue({ args0 -> args0 })

    /**
     * The cryptographic operations for which you can use the CMK.
     */
    public val keyUsage: Output<String>
        get() = javaResource.keyUsage().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the KMS key is a multi-Region (`true`) or regional (`false`) key. Defaults to `false`.
     */
    public val multiRegion: Output<Boolean>
        get() = javaResource.multiRegion().applyValue({ args0 -> args0 })

    /**
     * A key policy JSON document. If you do not provide a key policy, AWS KMS attaches a default key policy to the CMK.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * A key-value map of tags to assign to the key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Time at which the imported key material expires. When the key material expires, AWS KMS deletes the key material and the CMK becomes unusable. If not specified, key material does not expire. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val validTo: Output<String>?
        get() = javaResource.validTo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ExternalKeyMapper : ResourceMapper<ExternalKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.ExternalKey::class == javaResource::class

    override fun map(javaResource: Resource): ExternalKey = ExternalKey(
        javaResource as
            com.pulumi.aws.kms.ExternalKey,
    )
}

/**
 * @see [ExternalKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExternalKey].
 */
public suspend fun externalKey(name: String, block: suspend ExternalKeyResourceBuilder.() -> Unit): ExternalKey {
    val builder = ExternalKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExternalKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun externalKey(name: String): ExternalKey {
    val builder = ExternalKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
