@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.GrantArgs.builder
import com.pulumi.aws.kms.kotlin.inputs.GrantConstraintArgs
import com.pulumi.aws.kms.kotlin.inputs.GrantConstraintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource-based access control mechanism for a KMS customer master key.
 * > **Note:** All arguments including the grant token will be stored in the raw state as plain-text.
 * ## Import
 * Using `pulumi import`, import KMS Grants using the Key ID and Grant ID separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:kms/grant:Grant test 1234abcd-12ab-34cd-56ef-1234567890ab:abcde1237f76e4ba7987489ac329fbfba6ad343d6f7075dbd1ef191f0120514
 * ```
 * @property constraints A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
 * @property grantCreationTokens A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
 * @property granteePrincipal The principal that is given permission to perform the operations that the grant permits in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
 * @property keyId The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN.
 * @property name A friendly name for identifying the grant.
 * @property operations A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
 * @property retireOnDelete If set to false (the default) the grants will be revoked upon deletion, and if set to true the grants will try to be retired upon deletion. Note that retiring grants requires special permissions, hence why we default to revoking grants.
 * See [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) for more information.
 * @property retiringPrincipal The principal that is given permission to retire the grant by using RetireGrant operation in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
 */
public data class GrantArgs(
    public val constraints: Output<List<GrantConstraintArgs>>? = null,
    public val grantCreationTokens: Output<List<String>>? = null,
    public val granteePrincipal: Output<String>? = null,
    public val keyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val operations: Output<List<String>>? = null,
    public val retireOnDelete: Output<Boolean>? = null,
    public val retiringPrincipal: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.GrantArgs> {
    override fun toJava(): com.pulumi.aws.kms.GrantArgs = com.pulumi.aws.kms.GrantArgs.builder()
        .constraints(
            constraints?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .grantCreationTokens(grantCreationTokens?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .granteePrincipal(granteePrincipal?.applyValue({ args0 -> args0 }))
        .keyId(keyId?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .operations(operations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .retireOnDelete(retireOnDelete?.applyValue({ args0 -> args0 }))
        .retiringPrincipal(retiringPrincipal?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GrantArgs].
 */
@PulumiTagMarker
public class GrantArgsBuilder internal constructor() {
    private var constraints: Output<List<GrantConstraintArgs>>? = null

    private var grantCreationTokens: Output<List<String>>? = null

    private var granteePrincipal: Output<String>? = null

    private var keyId: Output<String>? = null

    private var name: Output<String>? = null

    private var operations: Output<List<String>>? = null

    private var retireOnDelete: Output<Boolean>? = null

    private var retiringPrincipal: Output<String>? = null

    /**
     * @param value A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("viraidhyonwvhxxx")
    public suspend fun constraints(`value`: Output<List<GrantConstraintArgs>>) {
        this.constraints = value
    }

    @JvmName("ewqjfwrvxyyhsswl")
    public suspend fun constraints(vararg values: Output<GrantConstraintArgs>) {
        this.constraints = Output.all(values.asList())
    }

    /**
     * @param values A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("nbrdqfvxwkkjfrot")
    public suspend fun constraints(values: List<Output<GrantConstraintArgs>>) {
        this.constraints = Output.all(values)
    }

    /**
     * @param value A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
     */
    @JvmName("clmsygtdouhnuqwf")
    public suspend fun grantCreationTokens(`value`: Output<List<String>>) {
        this.grantCreationTokens = value
    }

    @JvmName("injrrfpusnlrlrpd")
    public suspend fun grantCreationTokens(vararg values: Output<String>) {
        this.grantCreationTokens = Output.all(values.asList())
    }

    /**
     * @param values A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
     */
    @JvmName("vmntddvsmyoatdyn")
    public suspend fun grantCreationTokens(values: List<Output<String>>) {
        this.grantCreationTokens = Output.all(values)
    }

    /**
     * @param value The principal that is given permission to perform the operations that the grant permits in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    @JvmName("bbmvewklnhgmsqvg")
    public suspend fun granteePrincipal(`value`: Output<String>) {
        this.granteePrincipal = value
    }

    /**
     * @param value The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN.
     */
    @JvmName("pdexpyahroovhiod")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value A friendly name for identifying the grant.
     */
    @JvmName("kchlfugxcaubetdg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
     */
    @JvmName("upnbtbvpoflishla")
    public suspend fun operations(`value`: Output<List<String>>) {
        this.operations = value
    }

    @JvmName("rardmlsmudlxrfsw")
    public suspend fun operations(vararg values: Output<String>) {
        this.operations = Output.all(values.asList())
    }

    /**
     * @param values A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
     */
    @JvmName("mgjqcxvlabriebxo")
    public suspend fun operations(values: List<Output<String>>) {
        this.operations = Output.all(values)
    }

    /**
     * @param value If set to false (the default) the grants will be revoked upon deletion, and if set to true the grants will try to be retired upon deletion. Note that retiring grants requires special permissions, hence why we default to revoking grants.
     * See [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) for more information.
     */
    @JvmName("hyveojiwhecpwcwh")
    public suspend fun retireOnDelete(`value`: Output<Boolean>) {
        this.retireOnDelete = value
    }

    /**
     * @param value The principal that is given permission to retire the grant by using RetireGrant operation in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    @JvmName("pgixowkjljljvmmg")
    public suspend fun retiringPrincipal(`value`: Output<String>) {
        this.retiringPrincipal = value
    }

    /**
     * @param value A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("lpatqlbvetukenro")
    public suspend fun constraints(`value`: List<GrantConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constraints = mapped
    }

    /**
     * @param argument A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("eafefavnmtcferqo")
    public suspend fun constraints(argument: List<suspend GrantConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GrantConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.constraints = mapped
    }

    /**
     * @param argument A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("awvxyetybcjyyuvn")
    public suspend fun constraints(vararg argument: suspend GrantConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GrantConstraintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.constraints = mapped
    }

    /**
     * @param argument A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("hyppgjkcwcneiyaj")
    public suspend fun constraints(argument: suspend GrantConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GrantConstraintArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.constraints = mapped
    }

    /**
     * @param values A structure that you can use to allow certain operations in the grant only when the desired encryption context is present. For more information about encryption context, see [Encryption Context](http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
     */
    @JvmName("pcunnbjpasnacquf")
    public suspend fun constraints(vararg values: GrantConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.constraints = mapped
    }

    /**
     * @param value A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
     */
    @JvmName("bkfpeisatqrkrlyn")
    public suspend fun grantCreationTokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantCreationTokens = mapped
    }

    /**
     * @param values A list of grant tokens to be used when creating the grant. See [Grant Tokens](http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token) for more information about grant tokens.
     */
    @JvmName("vhyhigjkwcncdeav")
    public suspend fun grantCreationTokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grantCreationTokens = mapped
    }

    /**
     * @param value The principal that is given permission to perform the operations that the grant permits in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    @JvmName("mfsdgbsukmqtgcbx")
    public suspend fun granteePrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granteePrincipal = mapped
    }

    /**
     * @param value The unique identifier for the customer master key (CMK) that the grant applies to. Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify a CMK in a different AWS account, you must use the key ARN.
     */
    @JvmName("gbwojbddkuypwcws")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value A friendly name for identifying the grant.
     */
    @JvmName("enchqmrxlvbttaep")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
     */
    @JvmName("ravihfwkfwxaiuse")
    public suspend fun operations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    /**
     * @param values A list of operations that the grant permits. The permitted values are: `Decrypt`, `Encrypt`, `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext`, `ReEncryptFrom`, `ReEncryptTo`, `Sign`, `Verify`, `GetPublicKey`, `CreateGrant`, `RetireGrant`, `DescribeKey`, `GenerateDataKeyPair`, or `GenerateDataKeyPairWithoutPlaintext`.
     */
    @JvmName("smkgboyxvuubtnxp")
    public suspend fun operations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    /**
     * @param value If set to false (the default) the grants will be revoked upon deletion, and if set to true the grants will try to be retired upon deletion. Note that retiring grants requires special permissions, hence why we default to revoking grants.
     * See [RetireGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html) for more information.
     */
    @JvmName("ihcuckdxixdhgref")
    public suspend fun retireOnDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retireOnDelete = mapped
    }

    /**
     * @param value The principal that is given permission to retire the grant by using RetireGrant operation in ARN format. Note that due to eventual consistency issues around IAM principals, the providers's state may not always be refreshed to reflect what is true in AWS.
     */
    @JvmName("rbgtvbgiiaqepkeh")
    public suspend fun retiringPrincipal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retiringPrincipal = mapped
    }

    internal fun build(): GrantArgs = GrantArgs(
        constraints = constraints,
        grantCreationTokens = grantCreationTokens,
        granteePrincipal = granteePrincipal,
        keyId = keyId,
        name = name,
        operations = operations,
        retireOnDelete = retireOnDelete,
        retiringPrincipal = retiringPrincipal,
    )
}
