@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReplicaKey].
 */
@PulumiTagMarker
public class ReplicaKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicaKeyArgs = ReplicaKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicaKeyArgsBuilder.() -> Unit) {
        val builder = ReplicaKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicaKey {
        val builtJavaResource = com.pulumi.aws.kms.ReplicaKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicaKey(builtJavaResource)
    }
}

/**
 * Manages a KMS multi-Region replica key.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.kms.Key("primary", {
 *     description: "Multi-Region primary key",
 *     deletionWindowInDays: 30,
 *     multiRegion: true,
 * });
 * const replica = new aws.kms.ReplicaKey("replica", {
 *     description: "Multi-Region replica key",
 *     deletionWindowInDays: 7,
 *     primaryKeyArn: primary.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.kms.Key("primary",
 *     description="Multi-Region primary key",
 *     deletion_window_in_days=30,
 *     multi_region=True)
 * replica = aws.kms.ReplicaKey("replica",
 *     description="Multi-Region replica key",
 *     deletion_window_in_days=7,
 *     primary_key_arn=primary.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.Kms.Key("primary", new()
 *     {
 *         Description = "Multi-Region primary key",
 *         DeletionWindowInDays = 30,
 *         MultiRegion = true,
 *     });
 *     var replica = new Aws.Kms.ReplicaKey("replica", new()
 *     {
 *         Description = "Multi-Region replica key",
 *         DeletionWindowInDays = 7,
 *         PrimaryKeyArn = primary.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := kms.NewKey(ctx, "primary", &kms.KeyArgs{
 * 			Description:          pulumi.String("Multi-Region primary key"),
 * 			DeletionWindowInDays: pulumi.Int(30),
 * 			MultiRegion:          pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewReplicaKey(ctx, "replica", &kms.ReplicaKeyArgs{
 * 			Description:          pulumi.String("Multi-Region replica key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			PrimaryKeyArn:        primary.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.ReplicaKey;
 * import com.pulumi.aws.kms.ReplicaKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Key("primary", KeyArgs.builder()
 *             .description("Multi-Region primary key")
 *             .deletionWindowInDays(30)
 *             .multiRegion(true)
 *             .build());
 *         var replica = new ReplicaKey("replica", ReplicaKeyArgs.builder()
 *             .description("Multi-Region replica key")
 *             .deletionWindowInDays(7)
 *             .primaryKeyArn(primary.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:kms:Key
 *     properties:
 *       description: Multi-Region primary key
 *       deletionWindowInDays: 30
 *       multiRegion: true
 *   replica:
 *     type: aws:kms:ReplicaKey
 *     properties:
 *       description: Multi-Region replica key
 *       deletionWindowInDays: 7
 *       primaryKeyArn: ${primary.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import KMS multi-Region replica keys using the `id`. For example:
 * ```sh
 * $ pulumi import aws:kms/replicaKey:ReplicaKey example 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 */
public class ReplicaKey internal constructor(
    override val javaResource: com.pulumi.aws.kms.ReplicaKey,
) : KotlinCustomResource(javaResource, ReplicaKeyMapper) {
    /**
     * The Amazon Resource Name (ARN) of the replica key. The key ARNs of related multi-Region keys differ only in the Region value.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>?
        get() = javaResource.bypassPolicyLockoutSafetyCheck().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     */
    public val deletionWindowInDays: Output<Int>?
        get() = javaResource.deletionWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A description of the KMS key.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations. The default value is `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The key ID of the replica key. Related multi-Region keys have the same key ID.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * A Boolean value that specifies whether key rotation is enabled. This is a shared property of multi-Region keys.
     */
    public val keyRotationEnabled: Output<Boolean>
        get() = javaResource.keyRotationEnabled().applyValue({ args0 -> args0 })

    /**
     * The type of key material in the KMS key. This is a shared property of multi-Region keys.
     */
    public val keySpec: Output<String>
        get() = javaResource.keySpec().applyValue({ args0 -> args0 })

    /**
     * The [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. This is a shared property of multi-Region keys.
     */
    public val keyUsage: Output<String>
        get() = javaResource.keyUsage().applyValue({ args0 -> args0 })

    /**
     * The key policy to attach to the KMS key. If you do not specify a key policy, AWS KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The ARN of the multi-Region primary key to replicate. The primary key must be in a different AWS Region of the same AWS Partition. You can create only one replica of a given primary key in each AWS Region.
     */
    public val primaryKeyArn: Output<String>
        get() = javaResource.primaryKeyArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ReplicaKeyMapper : ResourceMapper<ReplicaKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.kms.ReplicaKey::class == javaResource::class

    override fun map(javaResource: Resource): ReplicaKey = ReplicaKey(
        javaResource as
            com.pulumi.aws.kms.ReplicaKey,
    )
}

/**
 * @see [ReplicaKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicaKey].
 */
public suspend fun replicaKey(name: String, block: suspend ReplicaKeyResourceBuilder.() -> Unit): ReplicaKey {
    val builder = ReplicaKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicaKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicaKey(name: String): ReplicaKey {
    val builder = ReplicaKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
