@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin

import com.pulumi.aws.kms.ReplicaKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a KMS multi-Region replica key.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.kms.Key("primary", {
 *     description: "Multi-Region primary key",
 *     deletionWindowInDays: 30,
 *     multiRegion: true,
 * });
 * const replica = new aws.kms.ReplicaKey("replica", {
 *     description: "Multi-Region replica key",
 *     deletionWindowInDays: 7,
 *     primaryKeyArn: primary.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.kms.Key("primary",
 *     description="Multi-Region primary key",
 *     deletion_window_in_days=30,
 *     multi_region=True)
 * replica = aws.kms.ReplicaKey("replica",
 *     description="Multi-Region replica key",
 *     deletion_window_in_days=7,
 *     primary_key_arn=primary.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.Kms.Key("primary", new()
 *     {
 *         Description = "Multi-Region primary key",
 *         DeletionWindowInDays = 30,
 *         MultiRegion = true,
 *     });
 *     var replica = new Aws.Kms.ReplicaKey("replica", new()
 *     {
 *         Description = "Multi-Region replica key",
 *         DeletionWindowInDays = 7,
 *         PrimaryKeyArn = primary.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := kms.NewKey(ctx, "primary", &kms.KeyArgs{
 * 			Description:          pulumi.String("Multi-Region primary key"),
 * 			DeletionWindowInDays: pulumi.Int(30),
 * 			MultiRegion:          pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewReplicaKey(ctx, "replica", &kms.ReplicaKeyArgs{
 * 			Description:          pulumi.String("Multi-Region replica key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			PrimaryKeyArn:        primary.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.kms.ReplicaKey;
 * import com.pulumi.aws.kms.ReplicaKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Key("primary", KeyArgs.builder()
 *             .description("Multi-Region primary key")
 *             .deletionWindowInDays(30)
 *             .multiRegion(true)
 *             .build());
 *         var replica = new ReplicaKey("replica", ReplicaKeyArgs.builder()
 *             .description("Multi-Region replica key")
 *             .deletionWindowInDays(7)
 *             .primaryKeyArn(primary.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:kms:Key
 *     properties:
 *       description: Multi-Region primary key
 *       deletionWindowInDays: 30
 *       multiRegion: true
 *   replica:
 *     type: aws:kms:ReplicaKey
 *     properties:
 *       description: Multi-Region replica key
 *       deletionWindowInDays: 7
 *       primaryKeyArn: ${primary.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import KMS multi-Region replica keys using the `id`. For example:
 * ```sh
 * $ pulumi import aws:kms/replicaKey:ReplicaKey example 1234abcd-12ab-34cd-56ef-1234567890ab
 * ```
 * @property bypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety check.
 * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
 * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
 * The default value is `false`.
 * @property deletionWindowInDays The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
 * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
 * @property description A description of the KMS key.
 * @property enabled Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations. The default value is `true`.
 * @property policy The key policy to attach to the KMS key. If you do not specify a key policy, AWS KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
 * @property primaryKeyArn The ARN of the multi-Region primary key to replicate. The primary key must be in a different AWS Region of the same AWS Partition. You can create only one replica of a given primary key in each AWS Region.
 * @property tags A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReplicaKeyArgs(
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null,
    public val deletionWindowInDays: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val primaryKeyArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.ReplicaKeyArgs> {
    override fun toJava(): com.pulumi.aws.kms.ReplicaKeyArgs =
        com.pulumi.aws.kms.ReplicaKeyArgs.builder()
            .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck?.applyValue({ args0 -> args0 }))
            .deletionWindowInDays(deletionWindowInDays?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .primaryKeyArn(primaryKeyArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicaKeyArgs].
 */
@PulumiTagMarker
public class ReplicaKeyArgsBuilder internal constructor() {
    private var bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null

    private var deletionWindowInDays: Output<Int>? = null

    private var description: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var primaryKeyArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    @JvmName("acdlduosvpqkcqqp")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Output<Boolean>) {
        this.bypassPolicyLockoutSafetyCheck = value
    }

    /**
     * @param value The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     */
    @JvmName("xsvfllnkkaglcnbl")
    public suspend fun deletionWindowInDays(`value`: Output<Int>) {
        this.deletionWindowInDays = value
    }

    /**
     * @param value A description of the KMS key.
     */
    @JvmName("gnmnalxbxmnthppk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations. The default value is `true`.
     */
    @JvmName("fwosyguleskndggb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The key policy to attach to the KMS key. If you do not specify a key policy, AWS KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
     */
    @JvmName("asbueggfnhyvmfaw")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The ARN of the multi-Region primary key to replicate. The primary key must be in a different AWS Region of the same AWS Partition. You can create only one replica of a given primary key in each AWS Region.
     */
    @JvmName("mjgmfcdpcqcjyuwi")
    public suspend fun primaryKeyArn(`value`: Output<String>) {
        this.primaryKeyArn = value
    }

    /**
     * @param value A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ovbdgfegrtxsooyl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A flag to indicate whether to bypass the key policy lockout safety check.
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the _AWS Key Management Service Developer Guide_.
     * The default value is `false`.
     */
    @JvmName("blyqlxftybgvilss")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPolicyLockoutSafetyCheck = mapped
    }

    /**
     * @param value The waiting period, specified in number of days. After the waiting period ends, AWS KMS deletes the KMS key.
     * If you specify a value, it must be between `7` and `30`, inclusive. If you do not specify a value, it defaults to `30`.
     */
    @JvmName("qkqogmmtlssayewb")
    public suspend fun deletionWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionWindowInDays = mapped
    }

    /**
     * @param value A description of the KMS key.
     */
    @JvmName("vhvnnsugxbnkygdn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the replica key is enabled. Disabled KMS keys cannot be used in cryptographic operations. The default value is `true`.
     */
    @JvmName("pjlilwyhaaewwwwx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The key policy to attach to the KMS key. If you do not specify a key policy, AWS KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
     */
    @JvmName("iqfkjdtgyyilgdeb")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The ARN of the multi-Region primary key to replicate. The primary key must be in a different AWS Region of the same AWS Partition. You can create only one replica of a given primary key in each AWS Region.
     */
    @JvmName("yxtxtyjjvkoinbwb")
    public suspend fun primaryKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKeyArn = mapped
    }

    /**
     * @param value A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qgvvyhocjcoregfx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the replica key. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jaxlkvnsashtdyun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicaKeyArgs = ReplicaKeyArgs(
        bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck,
        deletionWindowInDays = deletionWindowInDays,
        description = description,
        enabled = enabled,
        policy = policy,
        primaryKeyArn = primaryKeyArn,
        tags = tags,
    )
}
