@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlias.
 * @property name Display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
 */
public data class GetAliasPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetAliasPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetAliasPlainArgs =
        com.pulumi.aws.kms.inputs.GetAliasPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAliasPlainArgs].
 */
@PulumiTagMarker
public class GetAliasPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Display name of the alias. The name must start with the word "alias" followed by a forward slash (alias/)
     */
    @JvmName("wjgbqrysnwrwxnhf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetAliasPlainArgs = GetAliasPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
