@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKey.
 * @property grantTokens List of grant tokens
 * @property keyId Key identifier which can be one of the following format:
 * * Key ID. E.g: `1234abcd-12ab-34cd-56ef-1234567890ab`
 * * Key ARN. E.g.: `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
 * * Alias name. E.g.: `alias/my-key`
 * * Alias ARN: E.g.: `arn:aws:kms:us-east-1:111122223333:alias/my-key`
 */
public data class GetKeyPlainArgs(
    public val grantTokens: List<String>? = null,
    public val keyId: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetKeyPlainArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetKeyPlainArgs =
        com.pulumi.aws.kms.inputs.GetKeyPlainArgs.builder()
            .grantTokens(grantTokens?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyId(keyId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPlainArgsBuilder internal constructor() {
    private var grantTokens: List<String>? = null

    private var keyId: String? = null

    /**
     * @param value List of grant tokens
     */
    @JvmName("huejlecstsrcvgem")
    public suspend fun grantTokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param values List of grant tokens
     */
    @JvmName("rudqnwwyhnoswyjr")
    public suspend fun grantTokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param value Key identifier which can be one of the following format:
     * * Key ID. E.g: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Key ARN. E.g.: `arn:aws:kms:us-east-1:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * * Alias name. E.g.: `alias/my-key`
     * * Alias ARN: E.g.: `arn:aws:kms:us-east-1:111122223333:alias/my-key`
     */
    @JvmName("kpelmwhyyspovbae")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyId = mapped
    }

    internal fun build(): GetKeyPlainArgs = GetKeyPlainArgs(
        grantTokens = grantTokens,
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
    )
}
