@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GetSecretSecret.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property context
 * @property grantTokens
 * @property name
 * @property payload
 */
public data class GetSecretSecret(
    public val context: Map<String, String>? = null,
    public val grantTokens: List<String>? = null,
    public val name: String,
    public val payload: String,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GetSecretSecret> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GetSecretSecret =
        com.pulumi.aws.kms.inputs.GetSecretSecret.builder()
            .context(context?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .grantTokens(grantTokens?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.let({ args0 -> args0 }))
            .payload(payload.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretSecret].
 */
@PulumiTagMarker
public class GetSecretSecretBuilder internal constructor() {
    private var context: Map<String, String>? = null

    private var grantTokens: List<String>? = null

    private var name: String? = null

    private var payload: String? = null

    /**
     * @param value
     */
    @JvmName("xlacxwdqaevfhmqk")
    public suspend fun context(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param values
     */
    @JvmName("rotmkxqomqaialpy")
    public fun context(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.context = mapped
    }

    /**
     * @param value
     */
    @JvmName("bneonjblqnyjmoeo")
    public suspend fun grantTokens(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param values
     */
    @JvmName("nivosykrnxpefxqn")
    public suspend fun grantTokens(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.grantTokens = mapped
    }

    /**
     * @param value
     */
    @JvmName("fbflfxcoymwdovxy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("cxakbdmaukjbbstc")
    public suspend fun payload(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.payload = mapped
    }

    internal fun build(): GetSecretSecret = GetSecretSecret(
        context = context,
        grantTokens = grantTokens,
        name = name ?: throw PulumiNullFieldException("name"),
        payload = payload ?: throw PulumiNullFieldException("payload"),
    )
}
