@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.inputs

import com.pulumi.aws.kms.inputs.GrantConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionContextEquals A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
 * @property encryptionContextSubset A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
 */
public data class GrantConstraintArgs(
    public val encryptionContextEquals: Output<Map<String, String>>? = null,
    public val encryptionContextSubset: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.kms.inputs.GrantConstraintArgs> {
    override fun toJava(): com.pulumi.aws.kms.inputs.GrantConstraintArgs =
        com.pulumi.aws.kms.inputs.GrantConstraintArgs.builder()
            .encryptionContextEquals(
                encryptionContextEquals?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .encryptionContextSubset(
                encryptionContextSubset?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GrantConstraintArgs].
 */
@PulumiTagMarker
public class GrantConstraintArgsBuilder internal constructor() {
    private var encryptionContextEquals: Output<Map<String, String>>? = null

    private var encryptionContextSubset: Output<Map<String, String>>? = null

    /**
     * @param value A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
     */
    @JvmName("vayrreanexxkbwqe")
    public suspend fun encryptionContextEquals(`value`: Output<Map<String, String>>) {
        this.encryptionContextEquals = value
    }

    /**
     * @param value A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
     */
    @JvmName("gdlflvhyjphwllym")
    public suspend fun encryptionContextSubset(`value`: Output<Map<String, String>>) {
        this.encryptionContextSubset = value
    }

    /**
     * @param value A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
     */
    @JvmName("whawqtgucyddcomg")
    public suspend fun encryptionContextEquals(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionContextEquals = mapped
    }

    /**
     * @param values A list of key-value pairs that must match the encryption context in subsequent cryptographic operation requests. The grant allows the operation only when the encryption context in the request is the same as the encryption context specified in this constraint. Conflicts with `encryption_context_subset`.
     */
    @JvmName("tacoiiebwnuppeip")
    public fun encryptionContextEquals(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionContextEquals = mapped
    }

    /**
     * @param value A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
     */
    @JvmName("dqcybeuljamulejm")
    public suspend fun encryptionContextSubset(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionContextSubset = mapped
    }

    /**
     * @param values A list of key-value pairs that must be included in the encryption context of subsequent cryptographic operation requests. The grant allows the cryptographic operation only when the encryption context in the request includes the key-value pairs specified in this constraint, although it can include additional key-value pairs. Conflicts with `encryption_context_equals`.
     */
    @JvmName("vxoxyjfonpgxlvfn")
    public fun encryptionContextSubset(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionContextSubset = mapped
    }

    internal fun build(): GrantConstraintArgs = GrantConstraintArgs(
        encryptionContextEquals = encryptionContextEquals,
        encryptionContextSubset = encryptionContextSubset,
    )
}
