@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAlias.
 * @property arn Amazon Resource Name(ARN) of the key alias.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the alias
 * @property targetKeyArn ARN pointed to by the alias.
 * @property targetKeyId Key identifier pointed to by the alias.
 */
public data class GetAliasResult(
    public val arn: String,
    public val id: String,
    public val name: String,
    public val targetKeyArn: String,
    public val targetKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetAliasResult): GetAliasResult =
            GetAliasResult(
                arn = javaType.arn(),
                id = javaType.id(),
                name = javaType.name(),
                targetKeyArn = javaType.targetKeyArn(),
                targetKeyId = javaType.targetKeyId(),
            )
    }
}
