@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPublicKey.
 * @property arn Key ARN of the asymmetric CMK from which the public key was downloaded.
 * @property customerMasterKeySpec Type of the public key that was downloaded.
 * @property encryptionAlgorithms Encryption algorithms that AWS KMS supports for this key. Only set when the `key_usage` of the public key is `ENCRYPT_DECRYPT`.
 * @property grantTokens
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyId
 * @property keyUsage Permitted use of the public key. Valid values are `ENCRYPT_DECRYPT` or `SIGN_VERIFY`
 * @property publicKey Exported public key. The value is a DER-encoded X.509 public key, also known as SubjectPublicKeyInfo (SPKI), as defined in [RFC 5280](https://tools.ietf.org/html/rfc5280). The value is Base64-encoded.
 * @property publicKeyPem Exported public key. The value is Privacy Enhanced Mail (PEM) encoded.
 * @property signingAlgorithms Signing algorithms that AWS KMS supports for this key. Only set when the `key_usage` of the public key is `SIGN_VERIFY`.
 */
public data class GetPublicKeyResult(
    public val arn: String,
    public val customerMasterKeySpec: String,
    public val encryptionAlgorithms: List<String>,
    public val grantTokens: List<String>? = null,
    public val id: String,
    public val keyId: String,
    public val keyUsage: String,
    public val publicKey: String,
    public val publicKeyPem: String,
    public val signingAlgorithms: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetPublicKeyResult): GetPublicKeyResult = GetPublicKeyResult(
            arn = javaType.arn(),
            customerMasterKeySpec = javaType.customerMasterKeySpec(),
            encryptionAlgorithms = javaType.encryptionAlgorithms().map({ args0 -> args0 }),
            grantTokens = javaType.grantTokens().map({ args0 -> args0 }),
            id = javaType.id(),
            keyId = javaType.keyId(),
            keyUsage = javaType.keyUsage(),
            publicKey = javaType.publicKey(),
            publicKeyPem = javaType.publicKeyPem(),
            signingAlgorithms = javaType.signingAlgorithms().map({ args0 -> args0 }),
        )
    }
}
