@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecret.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property secrets
 */
public data class GetSecretResult(
    public val id: String,
    public val secrets: List<GetSecretSecret>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetSecretResult): GetSecretResult =
            GetSecretResult(
                id = javaType.id(),
                secrets = javaType.secrets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kms.kotlin.outputs.GetSecretSecret.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
