@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property context
 * @property grantTokens
 * @property name
 * @property payload
 */
public data class GetSecretSecret(
    public val context: Map<String, String>? = null,
    public val grantTokens: List<String>? = null,
    public val name: String,
    public val payload: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetSecretSecret): GetSecretSecret =
            GetSecretSecret(
                context = javaType.context().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                grantTokens = javaType.grantTokens().map({ args0 -> args0 }),
                name = javaType.name(),
                payload = javaType.payload(),
            )
    }
}
