@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSecrets.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property plaintext Map containing each `secret` `name` as the key with its decrypted plaintext value
 * @property secrets
 */
public data class GetSecretsResult(
    public val id: String,
    public val plaintext: Map<String, String>,
    public val secrets: List<GetSecretsSecret>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.kms.outputs.GetSecretsResult): GetSecretsResult =
            GetSecretsResult(
                id = javaType.id(),
                plaintext = javaType.plaintext().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                secrets = javaType.secrets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.kms.kotlin.outputs.GetSecretsSecret.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
