@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin

import com.pulumi.aws.AwsFunctions.getArnPlain
import com.pulumi.aws.AwsFunctions.getAvailabilityZonePlain
import com.pulumi.aws.AwsFunctions.getAvailabilityZonesPlain
import com.pulumi.aws.AwsFunctions.getBillingServiceAccountPlain
import com.pulumi.aws.AwsFunctions.getCallerIdentityPlain
import com.pulumi.aws.AwsFunctions.getDefaultTagsPlain
import com.pulumi.aws.AwsFunctions.getIpRangesPlain
import com.pulumi.aws.AwsFunctions.getPartitionPlain
import com.pulumi.aws.AwsFunctions.getRegionPlain
import com.pulumi.aws.AwsFunctions.getRegionsPlain
import com.pulumi.aws.AwsFunctions.getServicePlain
import com.pulumi.aws.AwsFunctions.getServicePrincipalPlain
import com.pulumi.aws.kotlin.inputs.GetArnPlainArgs
import com.pulumi.aws.kotlin.inputs.GetArnPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZoneFilter
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonePlainArgs
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonePlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesFilter
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesPlainArgs
import com.pulumi.aws.kotlin.inputs.GetAvailabilityZonesPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetBillingServiceAccountPlainArgs
import com.pulumi.aws.kotlin.inputs.GetBillingServiceAccountPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetCallerIdentityPlainArgs
import com.pulumi.aws.kotlin.inputs.GetCallerIdentityPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetDefaultTagsPlainArgs
import com.pulumi.aws.kotlin.inputs.GetDefaultTagsPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetIpRangesPlainArgs
import com.pulumi.aws.kotlin.inputs.GetIpRangesPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetPartitionPlainArgs
import com.pulumi.aws.kotlin.inputs.GetPartitionPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetRegionPlainArgs
import com.pulumi.aws.kotlin.inputs.GetRegionPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetRegionsFilter
import com.pulumi.aws.kotlin.inputs.GetRegionsPlainArgs
import com.pulumi.aws.kotlin.inputs.GetRegionsPlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.kotlin.inputs.GetServicePrincipalPlainArgs
import com.pulumi.aws.kotlin.inputs.GetServicePrincipalPlainArgsBuilder
import com.pulumi.aws.kotlin.outputs.GetArnResult
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZoneResult
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZonesResult
import com.pulumi.aws.kotlin.outputs.GetBillingServiceAccountResult
import com.pulumi.aws.kotlin.outputs.GetCallerIdentityResult
import com.pulumi.aws.kotlin.outputs.GetDefaultTagsResult
import com.pulumi.aws.kotlin.outputs.GetIpRangesResult
import com.pulumi.aws.kotlin.outputs.GetPartitionResult
import com.pulumi.aws.kotlin.outputs.GetRegionResult
import com.pulumi.aws.kotlin.outputs.GetRegionsResult
import com.pulumi.aws.kotlin.outputs.GetServicePrincipalResult
import com.pulumi.aws.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.kotlin.outputs.GetArnResult.Companion.toKotlin as getArnResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZoneResult.Companion.toKotlin as getAvailabilityZoneResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetAvailabilityZonesResult.Companion.toKotlin as getAvailabilityZonesResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetBillingServiceAccountResult.Companion.toKotlin as getBillingServiceAccountResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetCallerIdentityResult.Companion.toKotlin as getCallerIdentityResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetDefaultTagsResult.Companion.toKotlin as getDefaultTagsResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetIpRangesResult.Companion.toKotlin as getIpRangesResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetPartitionResult.Companion.toKotlin as getPartitionResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetRegionResult.Companion.toKotlin as getRegionResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetRegionsResult.Companion.toKotlin as getRegionsResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetServicePrincipalResult.Companion.toKotlin as getServicePrincipalResultToKotlin
import com.pulumi.aws.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object AwsFunctions {
    /**
     * Parses an ARN into its constituent parts.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const dbInstance = aws.getArn({
     *     arn: "arn:aws:rds:eu-west-1:123456789012:db:mysql-db",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * db_instance = aws.get_arn(arn="arn:aws:rds:eu-west-1:123456789012:db:mysql-db")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var dbInstance = Aws.GetArn.Invoke(new()
     *     {
     *         Arn = "arn:aws:rds:eu-west-1:123456789012:db:mysql-db",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetArn(ctx, &aws.GetArnArgs{
     * 			Arn: "arn:aws:rds:eu-west-1:123456789012:db:mysql-db",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetArnArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var dbInstance = AwsFunctions.getArn(GetArnArgs.builder()
     *             .arn("arn:aws:rds:eu-west-1:123456789012:db:mysql-db")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   dbInstance:
     *     fn::invoke:
     *       Function: aws:getArn
     *       Arguments:
     *         arn: arn:aws:rds:eu-west-1:123456789012:db:mysql-db
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getArn.
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(argument: GetArnPlainArgs): GetArnResult =
        getArnResultToKotlin(getArnPlain(argument.toJava()).await())

    /**
     * @see [getArn].
     * @param arn ARN to parse.
     * @param id
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(arn: String, id: String? = null): GetArnResult {
        val argument = GetArnPlainArgs(
            arn = arn,
            id = id,
        )
        return getArnResultToKotlin(getArnPlain(argument.toJava()).await())
    }

    /**
     * @see [getArn].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetArnPlainArgs].
     * @return A collection of values returned by getArn.
     */
    public suspend fun getArn(argument: suspend GetArnPlainArgsBuilder.() -> Unit): GetArnResult {
        val builder = GetArnPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArnResultToKotlin(getArnPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.getAvailabilityZone` provides details about a specific availability zone (AZ)
     * in the current region.
     * This can be used both to validate an availability zone given in a variable
     * and to split the AZ name into its component parts of an AWS region and an
     * AZ identifier letter. The latter may be useful e.g., for implementing a
     * consistent subnet numbering scheme across several regions by mapping both
     * the region and the subnet letter to network numbers.
     * This is different from the `aws.getAvailabilityZones` (plural) data source,
     * which provides a list of the available zones.
     * ## Example Usage
     * The following example shows how this data source might be used to derive
     * VPC and subnet CIDR prefixes systematically for an availability zone.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * import * as std from "@pulumi/std";
     * const config = new pulumi.Config();
     * const regionNumber = config.getObject("regionNumber") || {
     *     "ap-northeast-1": 5,
     *     "eu-central-1": 4,
     *     "us-east-1": 1,
     *     "us-west-1": 2,
     *     "us-west-2": 3,
     * };
     * const azNumber = config.getObject("azNumber") || {
     *     a: 1,
     *     b: 2,
     *     c: 3,
     *     d: 4,
     *     e: 5,
     *     f: 6,
     * };
     * // Retrieve the AZ where we want to create network resources
     * // This must be in the region selected on the AWS provider.
     * const example = aws.getAvailabilityZone({
     *     name: "eu-central-1a",
     * });
     * // Create a VPC for the region associated with the AZ
     * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: example.then(example => std.cidrsubnet({
     *     input: "10.0.0.0/8",
     *     newbits: 4,
     *     netnum: regionNumber[example&#46;region],
     * })).then(invoke => invoke.result)});
     * // Create a subnet for the AZ within the regional VPC
     * const exampleSubnet = new aws.ec2.Subnet("example", {
     *     vpcId: exampleVpc.id,
     *     cidrBlock: pulumi.all([exampleVpc&#46;cidrBlock, example])&#46;apply(([cidrBlock, example]) => std.cidrsubnetOutput({
     *         input: cidrBlock,
     *         newbits: 4,
     *         netnum: azNumber[example&#46;nameSuffix],
     *     })).apply(invoke => invoke.result),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * import pulumi_std as std
     * config = pulumi.Config()
     * region_number = config.get_object("regionNumber")
     * if region_number is None:
     *     region_number = {
     *         "ap-northeast-1": 5,
     *         "eu-central-1": 4,
     *         "us-east-1": 1,
     *         "us-west-1": 2,
     *         "us-west-2": 3,
     *     }
     * az_number = config.get_object("azNumber")
     * if az_number is None:
     *     az_number = {
     *         "a": 1,
     *         "b": 2,
     *         "c": 3,
     *         "d": 4,
     *         "e": 5,
     *         "f": 6,
     *     }
     * # Retrieve the AZ where we want to create network resources
     * # This must be in the region selected on the AWS provider.
     * example = aws.get_availability_zone(name="eu-central-1a")
     * # Create a VPC for the region associated with the AZ
     * example_vpc = aws.ec2.Vpc("example", cidr_block=std.cidrsubnet(input="10.0.0.0/8",
     *     newbits=4,
     *     netnum=region_number[example&#46;region]).result)
     * # Create a subnet for the AZ within the regional VPC
     * example_subnet = aws.ec2.Subnet("example",
     *     vpc_id=example_vpc.id,
     *     cidr_block=example_vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
     *         newbits=4,
     *         netnum=az_number[example&#46;name_suffix])).apply(lambda invoke: invoke.result))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * using Std = Pulumi.Std;
     * return await Deployment.RunAsync(() =>
     * {
     *     var config = new Config();
     *     var regionNumber = config.GetObject<dynamic>("regionNumber") ??
     *     {
     *         { "ap-northeast-1", 5 },
     *         { "eu-central-1", 4 },
     *         { "us-east-1", 1 },
     *         { "us-west-1", 2 },
     *         { "us-west-2", 3 },
     *     };
     *     var azNumber = config.GetObject<dynamic>("azNumber") ??
     *     {
     *         { "a", 1 },
     *         { "b", 2 },
     *         { "c", 3 },
     *         { "d", 4 },
     *         { "e", 5 },
     *         { "f", 6 },
     *     };
     *     // Retrieve the AZ where we want to create network resources
     *     // This must be in the region selected on the AWS provider.
     *     var example = Aws.GetAvailabilityZone.Invoke(new()
     *     {
     *         Name = "eu-central-1a",
     *     });
     *     // Create a VPC for the region associated with the AZ
     *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
     *     {
     *         CidrBlock = Std.Cidrsubnet.Invoke(new()
     *         {
     *             Input = "10.0.0.0/8",
     *             Newbits = 4,
     *             Netnum = regionNumber[example&#46;Apply(getAvailabilityZoneResult => getAvailabilityZoneResult&#46;Region)],
     *         }).Apply(invoke => invoke.Result),
     *     });
     *     // Create a subnet for the AZ within the regional VPC
     *     var exampleSubnet = new Aws.Ec2.Subnet("example", new()
     *     {
     *         VpcId = exampleVpc.Id,
     *         CidrBlock = Output.Tuple(exampleVpc.CidrBlock, example).Apply(values =>
     *         {
     *             var cidrBlock = values.Item1;
     *             var example = values.Item2;
     *             return Std.Cidrsubnet.Invoke(new()
     *             {
     *                 Input = cidrBlock,
     *                 Newbits = 4,
     *                 Netnum = azNumber[example&#46;Apply(getAvailabilityZoneResult => getAvailabilityZoneResult&#46;NameSuffix)],
     *             });
     *         }).Apply(invoke => invoke.Result),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi-std/sdk/go/std"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		cfg := config.New(ctx, "")
     * 		regionNumber := map[string]interface{}{
     * 			"ap-northeast-1": 5,
     * 			"eu-central-1":   4,
     * 			"us-east-1":      1,
     * 			"us-west-1":      2,
     * 			"us-west-2":      3,
     * 		}
     * 		if param := cfg.GetObject("regionNumber"); param != nil {
     * 			regionNumber = param
     * 		}
     * 		azNumber := map[string]interface{}{
     * 			"a": 1,
     * 			"b": 2,
     * 			"c": 3,
     * 			"d": 4,
     * 			"e": 5,
     * 			"f": 6,
     * 		}
     * 		if param := cfg.GetObject("azNumber"); param != nil {
     * 			azNumber = param
     * 		}
     * 		// Retrieve the AZ where we want to create network resources
     * 		// This must be in the region selected on the AWS provider.
     * 		example, err := aws.GetAvailabilityZone(ctx, &aws.GetAvailabilityZoneArgs{
     * 			Name: pulumi.StringRef("eu-central-1a"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		invokeCidrsubnet, err := std.Cidrsubnet(ctx, &std.CidrsubnetArgs{
     * 			Input:   "10.0.0.0/8",
     * 			Newbits: 4,
     * 			Netnum:  regionNumber[example&#46;Region],
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a VPC for the region associated with the AZ
     * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
     * 			CidrBlock: pulumi.String(invokeCidrsubnet.Result),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create a subnet for the AZ within the regional VPC
     * 		_, err = ec2.NewSubnet(ctx, "example", &ec2.SubnetArgs{
     * 			VpcId: exampleVpc.ID(),
     * 			CidrBlock: pulumi.String(exampleVpc.CidrBlock.ApplyT(func(cidrBlock string) (std.CidrsubnetResult, error) {
     * 				return std.CidrsubnetResult(interface{}(std.CidrsubnetOutput(ctx, std.CidrsubnetOutputArgs{
     * 					Input:   cidrBlock,
     * 					Newbits: 4,
     * 					Netnum:  pulumi.Int(azNumber[example&#46;NameSuffix]),
     * 				}, nil))), nil
     * 			}).(std.CidrsubnetResultOutput).ApplyT(func(invoke std.CidrsubnetResult) (*string, error) {
     * 				return invoke.Result, nil
     * 			}).(pulumi.StringPtrOutput)),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZoneArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var regionNumber = config.get("regionNumber").orElse(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference));
     *         final var azNumber = config.get("azNumber").orElse(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference));
     *         // Retrieve the AZ where we want to create network resources
     *         // This must be in the region selected on the AWS provider.
     *         final var example = AwsFunctions.getAvailabilityZone(GetAvailabilityZoneArgs.builder()
     *             .name("eu-central-1a")
     *             .build());
     *         // Create a VPC for the region associated with the AZ
     *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
     *             .cidrBlock(StdFunctions.cidrsubnet(CidrsubnetArgs.builder()
     *                 .input("10.0.0.0/8")
     *                 .newbits(4)
     *                 .netnum(regionNumber[example&#46;applyValue(getAvailabilityZoneResult -> getAvailabilityZoneResult&#46;region())])
     *                 .build()).result())
     *             .build());
     *         // Create a subnet for the AZ within the regional VPC
     *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
     *             .vpcId(exampleVpc.id())
     *             .cidrBlock(exampleVpc.cidrBlock().applyValue(cidrBlock -> StdFunctions.cidrsubnet()).applyValue(invoke -> invoke.result()))
     *             .build());
     *     }
     * }
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAvailabilityZone.
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend fun getAvailabilityZone(argument: GetAvailabilityZonePlainArgs): GetAvailabilityZoneResult =
        getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(argument.toJava()).await())

    /**
     * @see [getAvailabilityZone].
     * @param allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param name Full name of the availability zone to select.
     * @param state Specific availability zone state to require. May be any of `"available"`, `"information"` or `"impaired"`.
     * @param zoneId Zone ID of the availability zone to select.
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend fun getAvailabilityZone(
        allAvailabilityZones: Boolean? = null,
        filters: List<GetAvailabilityZoneFilter>? = null,
        name: String? = null,
        state: String? = null,
        zoneId: String? = null,
    ): GetAvailabilityZoneResult {
        val argument = GetAvailabilityZonePlainArgs(
            allAvailabilityZones = allAvailabilityZones,
            filters = filters,
            name = name,
            state = state,
            zoneId = zoneId,
        )
        return getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilityZone].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetAvailabilityZonePlainArgs].
     * @return A collection of values returned by getAvailabilityZone.
     */
    public suspend fun getAvailabilityZone(argument: suspend GetAvailabilityZonePlainArgsBuilder.() -> Unit): GetAvailabilityZoneResult {
        val builder = GetAvailabilityZonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilityZoneResultToKotlin(getAvailabilityZonePlain(builtArgument.toJava()).await())
    }

    /**
     * The Availability Zones data source allows access to the list of AWS
     * Availability Zones which can be accessed by an AWS account within the region
     * configured in the provider.
     * This is different from the `aws.getAvailabilityZone` (singular) data source,
     * which provides some details about a specific availability zone.
     * > When [Local Zones](https://aws.amazon.com/about-aws/global-infrastructure/localzones/) are enabled in a region, by default the API and this data source include both Local Zones and Availability Zones. To return only Availability Zones, see the example section below.
     * ## Example Usage
     * ### By State
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * // Declare the data source
     * const available = aws.getAvailabilityZones({
     *     state: "available",
     * });
     * // e.g., Create subnets in the first two available availability zones
     * const primary = new aws.ec2.Subnet("primary", {availabilityZone: available.then(available => available.names?.[0])});
     * const secondary = new aws.ec2.Subnet("secondary", {availabilityZone: available.then(available => available.names?.[1])});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * # Declare the data source
     * available = aws.get_availability_zones(state="available")
     * # e.g., Create subnets in the first two available availability zones
     * primary = aws.ec2.Subnet("primary", availability_zone=available.names[0])
     * secondary = aws.ec2.Subnet("secondary", availability_zone=available.names[1])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var available = Aws.GetAvailabilityZones.Invoke(new()
     *     {
     *         State = "available",
     *     });
     *     // e.g., Create subnets in the first two available availability zones
     *     var primary = new Aws.Ec2.Subnet("primary", new()
     *     {
     *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[0]),
     *     });
     *     var secondary = new Aws.Ec2.Subnet("secondary", new()
     *     {
     *         AvailabilityZone = available.Apply(getAvailabilityZonesResult => getAvailabilityZonesResult.Names[1]),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		available, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
     * 			State: pulumi.StringRef("available"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// e.g., Create subnets in the first two available availability zones
     * 		_, err = ec2.NewSubnet(ctx, "primary", &ec2.SubnetArgs{
     * 			AvailabilityZone: pulumi.String(available.Names[0]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewSubnet(ctx, "secondary", &ec2.SubnetArgs{
     * 			AvailabilityZone: pulumi.String(available.Names[1]),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .state("available")
     *             .build());
     *         // e.g., Create subnets in the first two available availability zones
     *         var primary = new Subnet("primary", SubnetArgs.builder()
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
     *             .build());
     *         var secondary = new Subnet("secondary", SubnetArgs.builder()
     *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # e.g., Create subnets in the first two available availability zones
     *   primary:
     *     type: aws:ec2:Subnet
     *     properties:
     *       availabilityZone: ${available.names[0]}
     *   secondary:
     *     type: aws:ec2:Subnet
     *     properties:
     *       availabilityZone: ${available.names[1]}
     * variables:
     *   # Declare the data source
     *   available:
     *     fn::invoke:
     *       Function: aws:getAvailabilityZones
     *       Arguments:
     *         state: available
     * ```
     * <!--End PulumiCodeChooser -->
     * ### By Filter
     * All Local Zones (regardless of opt-in status):
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.getAvailabilityZones({
     *     allAvailabilityZones: true,
     *     filters: [{
     *         name: "opt-in-status",
     *         values: [
     *             "not-opted-in",
     *             "opted-in",
     *         ],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.get_availability_zones(all_availability_zones=True,
     *     filters=[{
     *         "name": "opt-in-status",
     *         "values": [
     *             "not-opted-in",
     *             "opted-in",
     *         ],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GetAvailabilityZones.Invoke(new()
     *     {
     *         AllAvailabilityZones = true,
     *         Filters = new[]
     *         {
     *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
     *             {
     *                 Name = "opt-in-status",
     *                 Values = new[]
     *                 {
     *                     "not-opted-in",
     *                     "opted-in",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
     * 			AllAvailabilityZones: pulumi.BoolRef(true),
     * 			Filters: []aws.GetAvailabilityZonesFilter{
     * 				{
     * 					Name: "opt-in-status",
     * 					Values: []string{
     * 						"not-opted-in",
     * 						"opted-in",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .allAvailabilityZones(true)
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name("opt-in-status")
     *                 .values(
     *                     "not-opted-in",
     *                     "opted-in")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:getAvailabilityZones
     *       Arguments:
     *         allAvailabilityZones: true
     *         filters:
     *           - name: opt-in-status
     *             values:
     *               - not-opted-in
     *               - opted-in
     * ```
     * <!--End PulumiCodeChooser -->
     * Only Availability Zones (no Local Zones):
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.getAvailabilityZones({
     *     filters: [{
     *         name: "opt-in-status",
     *         values: ["opt-in-not-required"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.get_availability_zones(filters=[{
     *     "name": "opt-in-status",
     *     "values": ["opt-in-not-required"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GetAvailabilityZones.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Inputs.GetAvailabilityZonesFilterInputArgs
     *             {
     *                 Name = "opt-in-status",
     *                 Values = new[]
     *                 {
     *                     "opt-in-not-required",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetAvailabilityZones(ctx, &aws.GetAvailabilityZonesArgs{
     * 			Filters: []aws.GetAvailabilityZonesFilter{
     * 				{
     * 					Name: "opt-in-status",
     * 					Values: []string{
     * 						"opt-in-not-required",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
     *             .filters(GetAvailabilityZonesFilterArgs.builder()
     *                 .name("opt-in-status")
     *                 .values("opt-in-not-required")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:getAvailabilityZones
     *       Arguments:
     *         filters:
     *           - name: opt-in-status
     *             values:
     *               - opt-in-not-required
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAvailabilityZones.
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend fun getAvailabilityZones(argument: GetAvailabilityZonesPlainArgs): GetAvailabilityZonesResult =
        getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(argument.toJava()).await())

    /**
     * @see [getAvailabilityZones].
     * @param allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     * @param excludeNames List of Availability Zone names to exclude.
     * @param excludeZoneIds List of Availability Zone IDs to exclude.
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param state Allows to filter list of Availability Zones based on their
     * current state. Can be either `"available"`, `"information"`, `"impaired"` or
     * `"unavailable"`. By default the list includes a complete set of Availability Zones
     * to which the underlying AWS account has access, regardless of their state.
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend fun getAvailabilityZones(
        allAvailabilityZones: Boolean? = null,
        excludeNames: List<String>? = null,
        excludeZoneIds: List<String>? = null,
        filters: List<GetAvailabilityZonesFilter>? = null,
        state: String? = null,
    ): GetAvailabilityZonesResult {
        val argument = GetAvailabilityZonesPlainArgs(
            allAvailabilityZones = allAvailabilityZones,
            excludeNames = excludeNames,
            excludeZoneIds = excludeZoneIds,
            filters = filters,
            state = state,
        )
        return getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAvailabilityZones].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetAvailabilityZonesPlainArgs].
     * @return A collection of values returned by getAvailabilityZones.
     */
    public suspend fun getAvailabilityZones(argument: suspend GetAvailabilityZonesPlainArgsBuilder.() -> Unit): GetAvailabilityZonesResult {
        val builder = GetAvailabilityZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAvailabilityZonesResultToKotlin(getAvailabilityZonesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the Account ID of the [AWS Billing and Cost Management Service Account](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-getting-started.html#step-2) for the purpose of permitting in S3 bucket policy.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const main = aws.getBillingServiceAccount({});
     * const billingLogs = new aws.s3.BucketV2("billing_logs", {bucket: "my-billing-tf-test-bucket"});
     * const billingLogsAcl = new aws.s3.BucketAclV2("billing_logs_acl", {
     *     bucket: billingLogs.id,
     *     acl: "private",
     * });
     * const allowBillingLogging = pulumi.all([main, billingLogs&#46;arn, main, billingLogs&#46;arn])&#46;apply(([main, billingLogsArn, main1, billingLogsArn1]) => aws.iam.getPolicyDocumentOutput({
     *     statements: [
     *         {
     *             effect: "Allow",
     *             principals: [{
     *                 type: "AWS",
     *                 identifiers: [main&#46;arn],
     *             }],
     *             actions: [
     *                 "s3:GetBucketAcl",
     *                 "s3:GetBucketPolicy",
     *             ],
     *             resources: [billingLogsArn],
     *         },
     *         {
     *             effect: "Allow",
     *             principals: [{
     *                 type: "AWS",
     *                 identifiers: [main1&#46;arn],
     *             }],
     *             actions: ["s3:PutObject"],
     *             resources: [`${billingLogsArn1}/*`],
     *         },
     *     ],
     * }));
     * const allowBillingLoggingBucketPolicy = new aws.s3.BucketPolicy("allow_billing_logging", {
     *     bucket: billingLogs.id,
     *     policy: allowBillingLogging.apply(allowBillingLogging => allowBillingLogging.json),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * main = aws.get_billing_service_account()
     * billing_logs = aws.s3.BucketV2("billing_logs", bucket="my-billing-tf-test-bucket")
     * billing_logs_acl = aws.s3.BucketAclV2("billing_logs_acl",
     *     bucket=billing_logs.id,
     *     acl="private")
     * allow_billing_logging = pulumi.Output.all(billing_logs.arn, billing_logs.arn).apply(lambda billingLogsArn, billingLogsArn1: aws.iam.get_policy_document_output(statements=[
     *     {
     *         "effect": "Allow",
     *         "principals": [{
     *             "type": "AWS",
     *             "identifiers": [main&#46;arn],
     *         }],
     *         "actions": [
     *             "s3:GetBucketAcl",
     *             "s3:GetBucketPolicy",
     *         ],
     *         "resources": [billing_logs_arn],
     *     },
     *     {
     *         "effect": "Allow",
     *         "principals": [{
     *             "type": "AWS",
     *             "identifiers": [main&#46;arn],
     *         }],
     *         "actions": ["s3:PutObject"],
     *         "resources": [f"{billing_logs_arn1}/*"],
     *     },
     * ]))
     * allow_billing_logging_bucket_policy = aws.s3.BucketPolicy("allow_billing_logging",
     *     bucket=billing_logs.id,
     *     policy=allow_billing_logging.json)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var main = Aws.GetBillingServiceAccount.Invoke();
     *     var billingLogs = new Aws.S3.BucketV2("billing_logs", new()
     *     {
     *         Bucket = "my-billing-tf-test-bucket",
     *     });
     *     var billingLogsAcl = new Aws.S3.BucketAclV2("billing_logs_acl", new()
     *     {
     *         Bucket = billingLogs.Id,
     *         Acl = "private",
     *     });
     *     var allowBillingLogging = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Principals = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "AWS",
     *                         Identifiers = new[]
     *                         {
     *                             main.Apply(getBillingServiceAccountResult => getBillingServiceAccountResult.Arn),
     *                         },
     *                     },
     *                 },
     *                 Actions = new[]
     *                 {
     *                     "s3:GetBucketAcl",
     *                     "s3:GetBucketPolicy",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     billingLogs.Arn,
     *                 },
     *             },
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Effect = "Allow",
     *                 Principals = new[]
     *                 {
     *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
     *                     {
     *                         Type = "AWS",
     *                         Identifiers = new[]
     *                         {
     *                             main.Apply(getBillingServiceAccountResult => getBillingServiceAccountResult.Arn),
     *                         },
     *                     },
     *                 },
     *                 Actions = new[]
     *                 {
     *                     "s3:PutObject",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     $"{billingLogs.Arn}/*",
     *                 },
     *             },
     *         },
     *     });
     *     var allowBillingLoggingBucketPolicy = new Aws.S3.BucketPolicy("allow_billing_logging", new()
     *     {
     *         Bucket = billingLogs.Id,
     *         Policy = allowBillingLogging.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * pulumi.Run(func(ctx *pulumi.Context) error {
     * main, err := aws.GetBillingServiceAccount(ctx, nil, nil);
     * if err != nil {
     * return err
     * }
     * billingLogs, err := s3.NewBucketV2(ctx, "billing_logs", &s3.BucketV2Args{
     * Bucket: pulumi.String("my-billing-tf-test-bucket"),
     * })
     * if err != nil {
     * return err
     * }
     * _, err = s3.NewBucketAclV2(ctx, "billing_logs_acl", &s3.BucketAclV2Args{
     * Bucket: billingLogs.ID(),
     * Acl: pulumi.String("private"),
     * })
     * if err != nil {
     * return err
     * }
     * allowBillingLogging := pulumi.All(billingLogs.Arn,billingLogs.Arn).ApplyT(func(_args []interface{}) (iam.GetPolicyDocumentResult, error) {
     * billingLogsArn := _args[0].(string)
     * billingLogsArn1 := _args[1].(string)
     * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
     * Statements: []iam.GetPolicyDocumentStatement{
     * {
     * Effect: "Allow",
     * Principals: []iam.GetPolicyDocumentStatementPrincipal{
     * {
     * Type: "AWS",
     * Identifiers: interface{}{
     * main.Arn,
     * },
     * },
     * },
     * Actions: []string{
     * "s3:GetBucketAcl",
     * "s3:GetBucketPolicy",
     * },
     * Resources: []string{
     * billingLogsArn,
     * },
     * },
     * {
     * Effect: "Allow",
     * Principals: []iam.GetPolicyDocumentStatementPrincipal{
     * {
     * Type: "AWS",
     * Identifiers: interface{}{
     * main.Arn,
     * },
     * },
     * },
     * Actions: []string{
     * "s3:PutObject",
     * },
     * Resources: []string{
     * fmt.Sprintf("%v/*", billingLogsArn1),
     * },
     * },
     * },
     * }, nil))), nil
     * }).(iam.GetPolicyDocumentResultOutput)
     * _, err = s3.NewBucketPolicy(ctx, "allow_billing_logging", &s3.BucketPolicyArgs{
     * Bucket: billingLogs.ID(),
     * Policy: pulumi.String(allowBillingLogging.ApplyT(func(allowBillingLogging iam.GetPolicyDocumentResult) (*string, error) {
     * return &allowBillingLogging.Json, nil
     * }).(pulumi.StringPtrOutput)),
     * })
     * if err != nil {
     * return err
     * }
     * return nil
     * })
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetBillingServiceAccountArgs;
     * import com.pulumi.aws.s3.BucketV2;
     * import com.pulumi.aws.s3.BucketV2Args;
     * import com.pulumi.aws.s3.BucketAclV2;
     * import com.pulumi.aws.s3.BucketAclV2Args;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import com.pulumi.aws.s3.BucketPolicy;
     * import com.pulumi.aws.s3.BucketPolicyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var main = AwsFunctions.getBillingServiceAccount();
     *         var billingLogs = new BucketV2("billingLogs", BucketV2Args.builder()
     *             .bucket("my-billing-tf-test-bucket")
     *             .build());
     *         var billingLogsAcl = new BucketAclV2("billingLogsAcl", BucketAclV2Args.builder()
     *             .bucket(billingLogs.id())
     *             .acl("private")
     *             .build());
     *         final var allowBillingLogging = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -> getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions(
     *                         "s3:GetBucketAcl",
     *                         "s3:GetBucketPolicy")
     *                     .resources(billingLogs.arn())
     *                     .build(),
     *                 GetPolicyDocumentStatementArgs.builder()
     *                     .effect("Allow")
     *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
     *                         .type("AWS")
     *                         .identifiers(main.applyValue(getBillingServiceAccountResult -> getBillingServiceAccountResult.arn()))
     *                         .build())
     *                     .actions("s3:PutObject")
     *                     .resources(billingLogs.arn().applyValue(arn -> String.format("%s/*", arn)))
     *                     .build())
     *             .build());
     *         var allowBillingLoggingBucketPolicy = new BucketPolicy("allowBillingLoggingBucketPolicy", BucketPolicyArgs.builder()
     *             .bucket(billingLogs.id())
     *             .policy(allowBillingLogging.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(allowBillingLogging -> allowBillingLogging.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   billingLogs:
     *     type: aws:s3:BucketV2
     *     name: billing_logs
     *     properties:
     *       bucket: my-billing-tf-test-bucket
     *   billingLogsAcl:
     *     type: aws:s3:BucketAclV2
     *     name: billing_logs_acl
     *     properties:
     *       bucket: ${billingLogs.id}
     *       acl: private
     *   allowBillingLoggingBucketPolicy:
     *     type: aws:s3:BucketPolicy
     *     name: allow_billing_logging
     *     properties:
     *       bucket: ${billingLogs.id}
     *       policy: ${allowBillingLogging.json}
     * variables:
     *   main:
     *     fn::invoke:
     *       Function: aws:getBillingServiceAccount
     *       Arguments: {}
     *   allowBillingLogging:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - effect: Allow
     *             principals:
     *               - type: AWS
     *                 identifiers:
     *                   - ${main.arn}
     *             actions:
     *               - s3:GetBucketAcl
     *               - s3:GetBucketPolicy
     *             resources:
     *               - ${billingLogs.arn}
     *           - effect: Allow
     *             principals:
     *               - type: AWS
     *                 identifiers:
     *                   - ${main.arn}
     *             actions:
     *               - s3:PutObject
     *             resources:
     *               - ${billingLogs.arn}/*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBillingServiceAccount.
     * @return A collection of values returned by getBillingServiceAccount.
     * */*/*/*/*/*/
     */
    public suspend fun getBillingServiceAccount(argument: GetBillingServiceAccountPlainArgs): GetBillingServiceAccountResult =
        getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(argument.toJava()).await())

    /**
     * @see [getBillingServiceAccount].
     * @param id ID of the AWS billing service account.
     * @return A collection of values returned by getBillingServiceAccount.
     */
    public suspend fun getBillingServiceAccount(id: String? = null): GetBillingServiceAccountResult {
        val argument = GetBillingServiceAccountPlainArgs(
            id = id,
        )
        return getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getBillingServiceAccount].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetBillingServiceAccountPlainArgs].
     * @return A collection of values returned by getBillingServiceAccount.
     */
    public suspend fun getBillingServiceAccount(argument: suspend GetBillingServiceAccountPlainArgsBuilder.() -> Unit): GetBillingServiceAccountResult {
        val builder = GetBillingServiceAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBillingServiceAccountResultToKotlin(getBillingServiceAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the access to the effective Account ID, User ID, and ARN in
     * which this provider is authorized.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getCallerIdentity({});
     * export const accountId = current.then(current => current.accountId);
     * export const callerArn = current.then(current => current.arn);
     * export const callerUser = current.then(current => current.userId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_caller_identity()
     * pulumi.export("accountId", current.account_id)
     * pulumi.export("callerArn", current.arn)
     * pulumi.export("callerUser", current.user_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetCallerIdentity.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["accountId"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId),
     *         ["callerArn"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
     *         ["callerUser"] = current.Apply(getCallerIdentityResult => getCallerIdentityResult.UserId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("accountId", current.AccountId)
     * 		ctx.Export("callerArn", current.Arn)
     * 		ctx.Export("callerUser", current.UserId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getCallerIdentity();
     *         ctx.export("accountId", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()));
     *         ctx.export("callerArn", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()));
     *         ctx.export("callerUser", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.userId()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getCallerIdentity
     *       Arguments: {}
     * outputs:
     *   accountId: ${current.accountId}
     *   callerArn: ${current.arn}
     *   callerUser: ${current.userId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCallerIdentity.
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(argument: GetCallerIdentityPlainArgs): GetCallerIdentityResult =
        getCallerIdentityResultToKotlin(getCallerIdentityPlain(argument.toJava()).await())

    /**
     * @see [getCallerIdentity].
     * @param id Account ID number of the account that owns or contains the calling entity.
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(id: String? = null): GetCallerIdentityResult {
        val argument = GetCallerIdentityPlainArgs(
            id = id,
        )
        return getCallerIdentityResultToKotlin(getCallerIdentityPlain(argument.toJava()).await())
    }

    /**
     * @see [getCallerIdentity].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetCallerIdentityPlainArgs].
     * @return A collection of values returned by getCallerIdentity.
     */
    public suspend fun getCallerIdentity(argument: suspend GetCallerIdentityPlainArgsBuilder.() -> Unit): GetCallerIdentityResult {
        val builder = GetCallerIdentityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCallerIdentityResultToKotlin(getCallerIdentityPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the default tags configured on the provider.
     * With this data source, you can apply default tags to resources not _directly_ managed by a resource, such as the instances underneath an Auto Scaling group or the volumes created for an EC2 instance.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.getDefaultTags({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.get_default_tags()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GetDefaultTags.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetDefaultTags(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetDefaultTagsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AwsFunctions.getDefaultTags();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:getDefaultTags
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Dynamically Apply Default Tags to Auto Scaling Group
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.getDefaultTags({});
     * const exampleGroup = new aws.autoscaling.Group("example", {tags: .map(entry => ({
     *     key: entry.key,
     *     value: entry.value,
     *     propagateAtLaunch: true,
     * }))});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.get_default_tags()
     * example_group = aws.autoscaling.Group("example", tags=[{
     *     "key": entry["key"],
     *     "value": entry["value"],
     *     "propagate_at_launch": True,
     * } for entry in [{"key": k, "value": v} for k, v in example&#46;tags]])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.GetDefaultTags.Invoke();
     *     var exampleGroup = new Aws.AutoScaling.Group("example", new()
     *     {
     *         Tags = ,
     *     });
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDefaultTags.
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(argument: GetDefaultTagsPlainArgs): GetDefaultTagsResult =
        getDefaultTagsResultToKotlin(getDefaultTagsPlain(argument.toJava()).await())

    /**
     * @see [getDefaultTags].
     * @param id
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(id: String? = null): GetDefaultTagsResult {
        val argument = GetDefaultTagsPlainArgs(
            id = id,
        )
        return getDefaultTagsResultToKotlin(getDefaultTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDefaultTags].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetDefaultTagsPlainArgs].
     * @return A collection of values returned by getDefaultTags.
     */
    public suspend fun getDefaultTags(argument: suspend GetDefaultTagsPlainArgsBuilder.() -> Unit): GetDefaultTagsResult {
        val builder = GetDefaultTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDefaultTagsResultToKotlin(getDefaultTagsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the IP ranges of various AWS products and services. For more information about the contents of this data source and required JSON syntax if referencing a custom URL, see the [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const europeanEc2 = aws.getIpRanges({
     *     regions: [
     *         "eu-west-1",
     *         "eu-central-1",
     *     ],
     *     services: ["ec2"],
     * });
     * const fromEurope = new aws.ec2.SecurityGroup("from_europe", {
     *     name: "from_europe",
     *     ingress: [{
     *         fromPort: 443,
     *         toPort: 443,
     *         protocol: "tcp",
     *         cidrBlocks: europeanEc2.then(europeanEc2 => europeanEc2.cidrBlocks),
     *         ipv6CidrBlocks: europeanEc2.then(europeanEc2 => europeanEc2.ipv6CidrBlocks),
     *     }],
     *     tags: {
     *         CreateDate: europeanEc2.then(europeanEc2 => europeanEc2.createDate),
     *         SyncToken: europeanEc2.then(europeanEc2 => europeanEc2.syncToken),
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * european_ec2 = aws.get_ip_ranges(regions=[
     *         "eu-west-1",
     *         "eu-central-1",
     *     ],
     *     services=["ec2"])
     * from_europe = aws.ec2.SecurityGroup("from_europe",
     *     name="from_europe",
     *     ingress=[{
     *         "from_port": 443,
     *         "to_port": 443,
     *         "protocol": "tcp",
     *         "cidr_blocks": european_ec2.cidr_blocks,
     *         "ipv6_cidr_blocks": european_ec2.ipv6_cidr_blocks,
     *     }],
     *     tags={
     *         "CreateDate": european_ec2.create_date,
     *         "SyncToken": european_ec2.sync_token,
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var europeanEc2 = Aws.GetIpRanges.Invoke(new()
     *     {
     *         Regions = new[]
     *         {
     *             "eu-west-1",
     *             "eu-central-1",
     *         },
     *         Services = new[]
     *         {
     *             "ec2",
     *         },
     *     });
     *     var fromEurope = new Aws.Ec2.SecurityGroup("from_europe", new()
     *     {
     *         Name = "from_europe",
     *         Ingress = new[]
     *         {
     *             new Aws.Ec2.Inputs.SecurityGroupIngressArgs
     *             {
     *                 FromPort = 443,
     *                 ToPort = 443,
     *                 Protocol = "tcp",
     *                 CidrBlocks = europeanEc2.Apply(getIpRangesResult => getIpRangesResult.CidrBlocks),
     *                 Ipv6CidrBlocks = europeanEc2.Apply(getIpRangesResult => getIpRangesResult.Ipv6CidrBlocks),
     *             },
     *         },
     *         Tags =
     *         {
     *             { "CreateDate", europeanEc2.Apply(getIpRangesResult => getIpRangesResult.CreateDate) },
     *             { "SyncToken", europeanEc2.Apply(getIpRangesResult => getIpRangesResult.SyncToken) },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		europeanEc2, err := aws.GetIpRanges(ctx, &aws.GetIpRangesArgs{
     * 			Regions: []string{
     * 				"eu-west-1",
     * 				"eu-central-1",
     * 			},
     * 			Services: []string{
     * 				"ec2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewSecurityGroup(ctx, "from_europe", &ec2.SecurityGroupArgs{
     * 			Name: pulumi.String("from_europe"),
     * 			Ingress: ec2.SecurityGroupIngressArray{
     * 				&ec2.SecurityGroupIngressArgs{
     * 					FromPort:       pulumi.Int(443),
     * 					ToPort:         pulumi.Int(443),
     * 					Protocol:       pulumi.String("tcp"),
     * 					CidrBlocks:     interface{}(europeanEc2.CidrBlocks),
     * 					Ipv6CidrBlocks: interface{}(europeanEc2.Ipv6CidrBlocks),
     * 				},
     * 			},
     * 			Tags: pulumi.StringMap{
     * 				"CreateDate": pulumi.String(europeanEc2.CreateDate),
     * 				"SyncToken":  pulumi.Int(europeanEc2.SyncToken),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetIpRangesArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var europeanEc2 = AwsFunctions.getIpRanges(GetIpRangesArgs.builder()
     *             .regions(
     *                 "eu-west-1",
     *                 "eu-central-1")
     *             .services("ec2")
     *             .build());
     *         var fromEurope = new SecurityGroup("fromEurope", SecurityGroupArgs.builder()
     *             .name("from_europe")
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .fromPort("443")
     *                 .toPort("443")
     *                 .protocol("tcp")
     *                 .cidrBlocks(europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.cidrBlocks()))
     *                 .ipv6CidrBlocks(europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.ipv6CidrBlocks()))
     *                 .build())
     *             .tags(Map.ofEntries(
     *                 Map.entry("CreateDate", europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.createDate())),
     *                 Map.entry("SyncToken", europeanEc2.applyValue(getIpRangesResult -> getIpRangesResult.syncToken()))
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   fromEurope:
     *     type: aws:ec2:SecurityGroup
     *     name: from_europe
     *     properties:
     *       name: from_europe
     *       ingress:
     *         - fromPort: '443'
     *           toPort: '443'
     *           protocol: tcp
     *           cidrBlocks: ${europeanEc2.cidrBlocks}
     *           ipv6CidrBlocks: ${europeanEc2.ipv6CidrBlocks}
     *       tags:
     *         CreateDate: ${europeanEc2.createDate}
     *         SyncToken: ${europeanEc2.syncToken}
     * variables:
     *   europeanEc2:
     *     fn::invoke:
     *       Function: aws:getIpRanges
     *       Arguments:
     *         regions:
     *           - eu-west-1
     *           - eu-central-1
     *         services:
     *           - ec2
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpRanges.
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(argument: GetIpRangesPlainArgs): GetIpRangesResult =
        getIpRangesResultToKotlin(getIpRangesPlain(argument.toJava()).await())

    /**
     * @see [getIpRanges].
     * @param id
     * @param regions Filter IP ranges by regions (or include all regions, if
     * omitted). Valid items are `global` (for `cloudfront`) as well as all AWS regions
     * (e.g., `eu-central-1`)
     * @param services Filter IP ranges by services. Valid items are `amazon`
     * (for amazon.com), `amazon_connect`, `api_gateway`, `cloud9`, `cloudfront`,
     * `codebuild`, `dynamodb`, `ec2`, `ec2_instance_connect`, `globalaccelerator`,
     * `route53`, `route53_healthchecks`, `s3` and `workspaces_gateways`. See the
     * [`service` attribute][2] documentation for other possible values.
     * > **NOTE:** If the specified combination of regions and services does not yield any
     * CIDR blocks, this call will fail.
     * @param url Custom URL for source JSON file. Syntax must match [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html). Defaults to `https://ip-ranges.amazonaws.com/ip-ranges.json`.
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(
        id: String? = null,
        regions: List<String>? = null,
        services: List<String>,
        url: String? = null,
    ): GetIpRangesResult {
        val argument = GetIpRangesPlainArgs(
            id = id,
            regions = regions,
            services = services,
            url = url,
        )
        return getIpRangesResultToKotlin(getIpRangesPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpRanges].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetIpRangesPlainArgs].
     * @return A collection of values returned by getIpRanges.
     */
    public suspend fun getIpRanges(argument: suspend GetIpRangesPlainArgsBuilder.() -> Unit): GetIpRangesResult {
        val builder = GetIpRangesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpRangesResultToKotlin(getIpRangesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to lookup information about the current AWS partition in
     * which the provider is working.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getPartition({});
     * const s3Policy = current.then(current => aws.iam.getPolicyDocument({
     *     statements: [{
     *         sid: "1",
     *         actions: ["s3:ListBucket"],
     *         resources: [`arn:${current&#46;partition}:s3:::my-bucket`],
     *     }],
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_partition()
     * s3_policy = aws.iam.get_policy_document(statements=[{
     *     "sid": "1",
     *     "actions": ["s3:ListBucket"],
     *     "resources": [f"arn:{current&#46;partition}:s3:::my-bucket"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetPartition.Invoke();
     *     var s3Policy = Aws.Iam.GetPolicyDocument.Invoke(new()
     *     {
     *         Statements = new[]
     *         {
     *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
     *             {
     *                 Sid = "1",
     *                 Actions = new[]
     *                 {
     *                     "s3:ListBucket",
     *                 },
     *                 Resources = new[]
     *                 {
     *                     $"arn:{current.Apply(getPartitionResult => getPartitionResult.Partition)}:s3:::my-bucket",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"fmt"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetPartition(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
     * 			Statements: []iam.GetPolicyDocumentStatement{
     * 				{
     * 					Sid: pulumi.StringRef("1"),
     * 					Actions: []string{
     * 						"s3:ListBucket",
     * 					},
     * 					Resources: []string{
     * 						fmt.Sprintf("arn:%v:s3:::my-bucket", current.Partition),
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetPartitionArgs;
     * import com.pulumi.aws.iam.IamFunctions;
     * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getPartition();
     *         final var s3Policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
     *             .statements(GetPolicyDocumentStatementArgs.builder()
     *                 .sid("1")
     *                 .actions("s3:ListBucket")
     *                 .resources(String.format("arn:%s:s3:::my-bucket", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getPartition
     *       Arguments: {}
     *   s3Policy:
     *     fn::invoke:
     *       Function: aws:iam:getPolicyDocument
     *       Arguments:
     *         statements:
     *           - sid: '1'
     *             actions:
     *               - s3:ListBucket
     *             resources:
     *               - arn:${current.partition}:s3:::my-bucket
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPartition.
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(argument: GetPartitionPlainArgs): GetPartitionResult =
        getPartitionResultToKotlin(getPartitionPlain(argument.toJava()).await())

    /**
     * @see [getPartition].
     * @param id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(id: String? = null): GetPartitionResult {
        val argument = GetPartitionPlainArgs(
            id = id,
        )
        return getPartitionResultToKotlin(getPartitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPartition].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetPartitionPlainArgs].
     * @return A collection of values returned by getPartition.
     */
    public suspend fun getPartition(argument: suspend GetPartitionPlainArgsBuilder.() -> Unit): GetPartitionResult {
        val builder = GetPartitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPartitionResultToKotlin(getPartitionPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.getRegion` provides details about a specific AWS region.
     * As well as validating a given region name this resource can be used to
     * discover the name of the region configured within the provider. The latter
     * can be useful in a child module which is inheriting an AWS provider
     * configuration from its parent module.
     * ## Example Usage
     * The following example shows how the resource might be used to obtain
     * the name of the AWS region configured on the provider.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegion({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_region()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegion.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetRegion(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegion
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegion.
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(argument: GetRegionPlainArgs): GetRegionResult =
        getRegionResultToKotlin(getRegionPlain(argument.toJava()).await())

    /**
     * @see [getRegion].
     * @param endpoint EC2 endpoint of the region to select.
     * @param id
     * @param name Full name of the region to select.
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(
        endpoint: String? = null,
        id: String? = null,
        name: String? = null,
    ): GetRegionResult {
        val argument = GetRegionPlainArgs(
            endpoint = endpoint,
            id = id,
            name = name,
        )
        return getRegionResultToKotlin(getRegionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetRegionPlainArgs].
     * @return A collection of values returned by getRegion.
     */
    public suspend fun getRegion(argument: suspend GetRegionPlainArgsBuilder.() -> Unit): GetRegionResult {
        val builder = GetRegionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionResultToKotlin(getRegionPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about AWS Regions. Can be used to filter regions i.e., by Opt-In status or only regions enabled for current account. To get details like endpoint and description of each region the data source can be combined with the `aws.getRegion` data source.
     * ## Example Usage
     * Enabled AWS Regions:
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegions({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_regions()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegions.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetRegions(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegions
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * All the regions regardless of the availability
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegions({
     *     allRegions: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_regions(all_regions=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegions.Invoke(new()
     *     {
     *         AllRegions = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetRegions(ctx, &aws.GetRegionsArgs{
     * 			AllRegions: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegions
     *       Arguments:
     *         allRegions: true
     * ```
     * <!--End PulumiCodeChooser -->
     * To see regions that are filtered by `"not-opted-in"`, the `all_regions` argument needs to be set to `true` or no results will be returned.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegions({
     *     allRegions: true,
     *     filters: [{
     *         name: "opt-in-status",
     *         values: ["not-opted-in"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_regions(all_regions=True,
     *     filters=[{
     *         "name": "opt-in-status",
     *         "values": ["not-opted-in"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegions.Invoke(new()
     *     {
     *         AllRegions = true,
     *         Filters = new[]
     *         {
     *             new Aws.Inputs.GetRegionsFilterInputArgs
     *             {
     *                 Name = "opt-in-status",
     *                 Values = new[]
     *                 {
     *                     "not-opted-in",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetRegions(ctx, &aws.GetRegionsArgs{
     * 			AllRegions: pulumi.BoolRef(true),
     * 			Filters: []aws.GetRegionsFilter{
     * 				{
     * 					Name: "opt-in-status",
     * 					Values: []string{
     * 						"not-opted-in",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegions(GetRegionsArgs.builder()
     *             .allRegions(true)
     *             .filters(GetRegionsFilterArgs.builder()
     *                 .name("opt-in-status")
     *                 .values("not-opted-in")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegions
     *       Arguments:
     *         allRegions: true
     *         filters:
     *           - name: opt-in-status
     *             values:
     *               - not-opted-in
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRegions.
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: GetRegionsPlainArgs): GetRegionsResult =
        getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())

    /**
     * @see [getRegions].
     * @param allRegions If true the source will query all regions regardless of availability.
     * @param filters Configuration block(s) to use as filters. Detailed below.
     * @param id Identifier of the current partition (e.g., `aws` in AWS Commercial, `aws-cn` in AWS China).
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(
        allRegions: Boolean? = null,
        filters: List<GetRegionsFilter>? = null,
        id: String? = null,
    ): GetRegionsResult {
        val argument = GetRegionsPlainArgs(
            allRegions = allRegions,
            filters = filters,
            id = id,
        )
        return getRegionsResultToKotlin(getRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetRegionsPlainArgs].
     * @return A collection of values returned by getRegions.
     */
    public suspend fun getRegions(argument: suspend GetRegionsPlainArgsBuilder.() -> Unit): GetRegionsResult {
        val builder = GetRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegionsResultToKotlin(getRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to compose and decompose AWS service DNS names.
     * ## Example Usage
     * ### Get Service DNS Name
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getRegion({});
     * const test = current.then(current => aws.getService({
     *     region: current.name,
     *     serviceId: "ec2",
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_region()
     * test = aws.get_service(region=current.name,
     *     service_id="ec2")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetRegion.Invoke();
     *     var test = Aws.GetService.Invoke(new()
     *     {
     *         Region = current.Apply(getRegionResult => getRegionResult.Name),
     *         ServiceId = "ec2",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		current, err := aws.GetRegion(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = aws.GetService(ctx, &aws.GetServiceArgs{
     * 			Region:    pulumi.StringRef(current.Name),
     * 			ServiceId: pulumi.StringRef("ec2"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *         final var test = AwsFunctions.getService(GetServiceArgs.builder()
     *             .region(current.applyValue(getRegionResult -> getRegionResult.name()))
     *             .serviceId("ec2")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getRegion
     *       Arguments: {}
     *   test:
     *     fn::invoke:
     *       Function: aws:getService
     *       Arguments:
     *         region: ${current.name}
     *         serviceId: ec2
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Use Service Reverse DNS Name to Get Components
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const s3 = aws.getService({
     *     reverseDnsName: "cn.com.amazonaws.cn-north-1.s3",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * s3 = aws.get_service(reverse_dns_name="cn.com.amazonaws.cn-north-1.s3")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var s3 = Aws.GetService.Invoke(new()
     *     {
     *         ReverseDnsName = "cn.com.amazonaws.cn-north-1.s3",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetService(ctx, &aws.GetServiceArgs{
     * 			ReverseDnsName: pulumi.StringRef("cn.com.amazonaws.cn-north-1.s3"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName("cn.com.amazonaws.cn-north-1.s3")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   s3:
     *     fn::invoke:
     *       Function: aws:getService
     *       Arguments:
     *         reverseDnsName: cn.com.amazonaws.cn-north-1.s3
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Determine Regional Support for a Service
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const s3 = aws.getService({
     *     reverseDnsName: "com.amazonaws.us-gov-west-1.waf",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * s3 = aws.get_service(reverse_dns_name="com.amazonaws.us-gov-west-1.waf")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var s3 = Aws.GetService.Invoke(new()
     *     {
     *         ReverseDnsName = "com.amazonaws.us-gov-west-1.waf",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetService(ctx, &aws.GetServiceArgs{
     * 			ReverseDnsName: pulumi.StringRef("com.amazonaws.us-gov-west-1.waf"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = AwsFunctions.getService(GetServiceArgs.builder()
     *             .reverseDnsName("com.amazonaws.us-gov-west-1.waf")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   s3:
     *     fn::invoke:
     *       Function: aws:getService
     *       Arguments:
     *         reverseDnsName: com.amazonaws.us-gov-west-1.waf
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param dnsName DNS name of the service (_e.g.,_ `rds.us-east-1.amazonaws.com`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @param id
     * @param region Region of the service (_e.g.,_ `us-west-2`, `ap-northeast-1`).
     * @param reverseDnsName Reverse DNS name of the service (_e.g.,_ `com.amazonaws.us-west-2.s3`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @param reverseDnsPrefix Prefix of the service (_e.g.,_ `com.amazonaws` in AWS Commercial, `cn.com.amazonaws` in AWS China).
     * @param serviceId Service (_e.g.,_ `s3`, `rds`, `ec2`). One of `dns_name`, `reverse_dns_name`, or `service_id` is required.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        dnsName: String? = null,
        id: String? = null,
        region: String? = null,
        reverseDnsName: String? = null,
        reverseDnsPrefix: String? = null,
        serviceId: String? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            dnsName = dnsName,
            id = id,
            region = region,
            reverseDnsName = reverseDnsName,
            reverseDnsPrefix = reverseDnsPrefix,
            serviceId = serviceId,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to create a Service Principal Name for a service in a given region. Service Principal Names should always end in the standard global format: `{servicename}.amazonaws.com`. However, in some AWS partitions, AWS may expect a different format.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.getServicePrincipal({
     *     serviceName: "s3",
     * });
     * const test = aws.getServicePrincipal({
     *     serviceName: "s3",
     *     region: "us-iso-east-1",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.get_service_principal(service_name="s3")
     * test = aws.get_service_principal(service_name="s3",
     *     region="us-iso-east-1")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.GetServicePrincipal.Invoke(new()
     *     {
     *         ServiceName = "s3",
     *     });
     *     var test = Aws.GetServicePrincipal.Invoke(new()
     *     {
     *         ServiceName = "s3",
     *         Region = "us-iso-east-1",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := aws.GetServicePrincipal(ctx, &aws.GetServicePrincipalArgs{
     * 			ServiceName: "s3",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = aws.GetServicePrincipal(ctx, &aws.GetServicePrincipalArgs{
     * 			ServiceName: "s3",
     * 			Region:      pulumi.StringRef("us-iso-east-1"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetServicePrincipalArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getServicePrincipal(GetServicePrincipalArgs.builder()
     *             .serviceName("s3")
     *             .build());
     *         final var test = AwsFunctions.getServicePrincipal(GetServicePrincipalArgs.builder()
     *             .serviceName("s3")
     *             .region("us-iso-east-1")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:getServicePrincipal
     *       Arguments:
     *         serviceName: s3
     *   test:
     *     fn::invoke:
     *       Function: aws:getServicePrincipal
     *       Arguments:
     *         serviceName: s3
     *         region: us-iso-east-1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServicePrincipal.
     * @return A collection of values returned by getServicePrincipal.
     */
    public suspend fun getServicePrincipal(argument: GetServicePrincipalPlainArgs): GetServicePrincipalResult =
        getServicePrincipalResultToKotlin(getServicePrincipalPlain(argument.toJava()).await())

    /**
     * @see [getServicePrincipal].
     * @param region Region you'd like the SPN for. By default, uses the current region.
     * @param serviceName Name of the service you want to generate a Service Principal Name for.
     * @return A collection of values returned by getServicePrincipal.
     */
    public suspend fun getServicePrincipal(region: String? = null, serviceName: String): GetServicePrincipalResult {
        val argument = GetServicePrincipalPlainArgs(
            region = region,
            serviceName = serviceName,
        )
        return getServicePrincipalResultToKotlin(getServicePrincipalPlain(argument.toJava()).await())
    }

    /**
     * @see [getServicePrincipal].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;kotlin&#46;inputs&#46;GetServicePrincipalPlainArgs].
     * @return A collection of values returned by getServicePrincipal.
     */
    public suspend fun getServicePrincipal(argument: suspend GetServicePrincipalPlainArgsBuilder.() -> Unit): GetServicePrincipalResult {
        val builder = GetServicePrincipalPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServicePrincipalResultToKotlin(getServicePrincipalPlain(builtArgument.toJava()).await())
    }
}
