@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetAvailabilityZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAvailabilityZone.
 * @property allAvailabilityZones Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property name Full name of the availability zone to select.
 * @property state Specific availability zone state to require. May be any of `"available"`, `"information"` or `"impaired"`.
 * @property zoneId Zone ID of the availability zone to select.
 */
public data class GetAvailabilityZonePlainArgs(
    public val allAvailabilityZones: Boolean? = null,
    public val filters: List<GetAvailabilityZoneFilter>? = null,
    public val name: String? = null,
    public val state: String? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetAvailabilityZonePlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetAvailabilityZonePlainArgs =
        com.pulumi.aws.inputs.GetAvailabilityZonePlainArgs.builder()
            .allAvailabilityZones(allAvailabilityZones?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAvailabilityZonePlainArgs].
 */
@PulumiTagMarker
public class GetAvailabilityZonePlainArgsBuilder internal constructor() {
    private var allAvailabilityZones: Boolean? = null

    private var filters: List<GetAvailabilityZoneFilter>? = null

    private var name: String? = null

    private var state: String? = null

    private var zoneId: String? = null

    /**
     * @param value Set to `true` to include all Availability Zones and Local Zones regardless of your opt in status.
     */
    @JvmName("waabksegsnkplmhc")
    public suspend fun allAvailabilityZones(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allAvailabilityZones = mapped
    }

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("iiwytrjngybncqde")
    public suspend fun filters(`value`: List<GetAvailabilityZoneFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gxjtsnfstrkfpiat")
    public suspend fun filters(argument: List<suspend GetAvailabilityZoneFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetAvailabilityZoneFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("sttaeerqopemfxlt")
    public suspend fun filters(vararg argument: suspend GetAvailabilityZoneFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetAvailabilityZoneFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("yxurwlmpodhodvgn")
    public suspend fun filters(argument: suspend GetAvailabilityZoneFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAvailabilityZoneFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("reygxlqrxhaphfvh")
    public suspend fun filters(vararg values: GetAvailabilityZoneFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Full name of the availability zone to select.
     */
    @JvmName("aaxbuucmycbemrsj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Specific availability zone state to require. May be any of `"available"`, `"information"` or `"impaired"`.
     */
    @JvmName("teasqwlyibmvqiqh")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    /**
     * @param value Zone ID of the availability zone to select.
     */
    @JvmName("siiytaolywacqglr")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetAvailabilityZonePlainArgs = GetAvailabilityZonePlainArgs(
        allAvailabilityZones = allAvailabilityZones,
        filters = filters,
        name = name,
        state = state,
        zoneId = zoneId,
    )
}
