@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetIpRangesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpRanges.
 * @property id
 * @property regions Filter IP ranges by regions (or include all regions, if
 * omitted). Valid items are `global` (for `cloudfront`) as well as all AWS regions
 * (e.g., `eu-central-1`)
 * @property services Filter IP ranges by services. Valid items are `amazon`
 * (for amazon.com), `amazon_connect`, `api_gateway`, `cloud9`, `cloudfront`,
 * `codebuild`, `dynamodb`, `ec2`, `ec2_instance_connect`, `globalaccelerator`,
 * `route53`, `route53_healthchecks`, `s3` and `workspaces_gateways`. See the
 * [`service` attribute][2] documentation for other possible values.
 * > **NOTE:** If the specified combination of regions and services does not yield any
 * CIDR blocks, this call will fail.
 * @property url Custom URL for source JSON file. Syntax must match [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html). Defaults to `https://ip-ranges.amazonaws.com/ip-ranges.json`.
 */
public data class GetIpRangesPlainArgs(
    public val id: String? = null,
    public val regions: List<String>? = null,
    public val services: List<String>,
    public val url: String? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetIpRangesPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetIpRangesPlainArgs =
        com.pulumi.aws.inputs.GetIpRangesPlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .regions(regions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .services(services.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .url(url?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpRangesPlainArgs].
 */
@PulumiTagMarker
public class GetIpRangesPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var regions: List<String>? = null

    private var services: List<String>? = null

    private var url: String? = null

    /**
     * @param value
     */
    @JvmName("opfnvxyunlviyhjj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Filter IP ranges by regions (or include all regions, if
     * omitted). Valid items are `global` (for `cloudfront`) as well as all AWS regions
     * (e.g., `eu-central-1`)
     */
    @JvmName("lbfjymupbnfhhrfi")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param values Filter IP ranges by regions (or include all regions, if
     * omitted). Valid items are `global` (for `cloudfront`) as well as all AWS regions
     * (e.g., `eu-central-1`)
     */
    @JvmName("gngfhymdwcyuxrcs")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.regions = mapped
    }

    /**
     * @param value Filter IP ranges by services. Valid items are `amazon`
     * (for amazon.com), `amazon_connect`, `api_gateway`, `cloud9`, `cloudfront`,
     * `codebuild`, `dynamodb`, `ec2`, `ec2_instance_connect`, `globalaccelerator`,
     * `route53`, `route53_healthchecks`, `s3` and `workspaces_gateways`. See the
     * [`service` attribute][2] documentation for other possible values.
     * > **NOTE:** If the specified combination of regions and services does not yield any
     * CIDR blocks, this call will fail.
     */
    @JvmName("uqfapkfvwlvdaxne")
    public suspend fun services(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.services = mapped
    }

    /**
     * @param values Filter IP ranges by services. Valid items are `amazon`
     * (for amazon.com), `amazon_connect`, `api_gateway`, `cloud9`, `cloudfront`,
     * `codebuild`, `dynamodb`, `ec2`, `ec2_instance_connect`, `globalaccelerator`,
     * `route53`, `route53_healthchecks`, `s3` and `workspaces_gateways`. See the
     * [`service` attribute][2] documentation for other possible values.
     * > **NOTE:** If the specified combination of regions and services does not yield any
     * CIDR blocks, this call will fail.
     */
    @JvmName("ampfgtjrfwncholn")
    public suspend fun services(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.services = mapped
    }

    /**
     * @param value Custom URL for source JSON file. Syntax must match [AWS IP Address Ranges documentation](https://docs.aws.amazon.com/general/latest/gr/aws-ip-ranges.html). Defaults to `https://ip-ranges.amazonaws.com/ip-ranges.json`.
     */
    @JvmName("rwqdbnstpyhvwiyh")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.url = mapped
    }

    internal fun build(): GetIpRangesPlainArgs = GetIpRangesPlainArgs(
        id = id,
        regions = regions,
        services = services ?: throw PulumiNullFieldException("services"),
        url = url,
    )
}
