@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.GetServicePrincipalPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServicePrincipal.
 * @property region Region you'd like the SPN for. By default, uses the current region.
 * @property serviceName Name of the service you want to generate a Service Principal Name for.
 */
public data class GetServicePrincipalPlainArgs(
    public val region: String? = null,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.aws.inputs.GetServicePrincipalPlainArgs> {
    override fun toJava(): com.pulumi.aws.inputs.GetServicePrincipalPlainArgs =
        com.pulumi.aws.inputs.GetServicePrincipalPlainArgs.builder()
            .region(region?.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePrincipalPlainArgs].
 */
@PulumiTagMarker
public class GetServicePrincipalPlainArgsBuilder internal constructor() {
    private var region: String? = null

    private var serviceName: String? = null

    /**
     * @param value Region you'd like the SPN for. By default, uses the current region.
     */
    @JvmName("svkikfyjvintpyln")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value Name of the service you want to generate a Service Principal Name for.
     */
    @JvmName("ofblsnbuubvkompb")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetServicePrincipalPlainArgs = GetServicePrincipalPlainArgs(
        region = region,
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
