@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderAssumeRoleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property duration The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
 * @property externalId A unique identifier that might be required when you assume a role in another account.
 * @property policy IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
 * @property policyArns Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
 * @property roleArn Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
 * @property sessionName An identifier for the assumed role session.
 * @property sourceIdentity Source identity specified by the principal assuming the role.
 * @property tags Assume role session tags.
 * @property transitiveTagKeys Assume role session tag keys to pass to any subsequent sessions.
 */
public data class ProviderAssumeRoleArgs(
    public val duration: Output<String>? = null,
    public val externalId: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val policyArns: Output<List<String>>? = null,
    public val roleArn: Output<String>? = null,
    public val sessionName: Output<String>? = null,
    public val sourceIdentity: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitiveTagKeys: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderAssumeRoleArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderAssumeRoleArgs =
        com.pulumi.aws.inputs.ProviderAssumeRoleArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .policyArns(policyArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 }))
            .sourceIdentity(sourceIdentity?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitiveTagKeys(transitiveTagKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProviderAssumeRoleArgs].
 */
@PulumiTagMarker
public class ProviderAssumeRoleArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var externalId: Output<String>? = null

    private var policy: Output<String>? = null

    private var policyArns: Output<List<String>>? = null

    private var roleArn: Output<String>? = null

    private var sessionName: Output<String>? = null

    private var sourceIdentity: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitiveTagKeys: Output<List<String>>? = null

    /**
     * @param value The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
     */
    @JvmName("qcxwhlaevxymuxxb")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value A unique identifier that might be required when you assume a role in another account.
     */
    @JvmName("hlphoeccnektvsia")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("cqfiyfphjqwiaytc")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("umsairbemapfafjn")
    public suspend fun policyArns(`value`: Output<List<String>>) {
        this.policyArns = value
    }

    @JvmName("bkdwmkvxalehsmch")
    public suspend fun policyArns(vararg values: Output<String>) {
        this.policyArns = Output.all(values.asList())
    }

    /**
     * @param values Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("khciruewyehsbwel")
    public suspend fun policyArns(values: List<Output<String>>) {
        this.policyArns = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
     */
    @JvmName("sgfifdrhsjgsmuag")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value An identifier for the assumed role session.
     */
    @JvmName("pcsnludtivukrvxf")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value Source identity specified by the principal assuming the role.
     */
    @JvmName("uwsorqrxpmhqkcsp")
    public suspend fun sourceIdentity(`value`: Output<String>) {
        this.sourceIdentity = value
    }

    /**
     * @param value Assume role session tags.
     */
    @JvmName("valfeucvuvhmkkai")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Assume role session tag keys to pass to any subsequent sessions.
     */
    @JvmName("aakerdooalcsmdvn")
    public suspend fun transitiveTagKeys(`value`: Output<List<String>>) {
        this.transitiveTagKeys = value
    }

    @JvmName("sigwlfbrmxihskmo")
    public suspend fun transitiveTagKeys(vararg values: Output<String>) {
        this.transitiveTagKeys = Output.all(values.asList())
    }

    /**
     * @param values Assume role session tag keys to pass to any subsequent sessions.
     */
    @JvmName("spxsujgdqhioroer")
    public suspend fun transitiveTagKeys(values: List<Output<String>>) {
        this.transitiveTagKeys = Output.all(values)
    }

    /**
     * @param value The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
     */
    @JvmName("esungeyhlbitusib")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value A unique identifier that might be required when you assume a role in another account.
     */
    @JvmName("ekywycscemtpixup")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("dldynskqlcewnnbi")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("cwhkrqefnowdibiy")
    public suspend fun policyArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param values Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
     */
    @JvmName("uiifyjprfqewlshk")
    public suspend fun policyArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyArns = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
     */
    @JvmName("piqftiturxnqtvoj")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value An identifier for the assumed role session.
     */
    @JvmName("huarjmpjqecmoudj")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    /**
     * @param value Source identity specified by the principal assuming the role.
     */
    @JvmName("ebfkwoiwoscahwwr")
    public suspend fun sourceIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIdentity = mapped
    }

    /**
     * @param value Assume role session tags.
     */
    @JvmName("xoyjprchulvbcaab")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Assume role session tags.
     */
    @JvmName("bljpxkkobqdbkgfl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Assume role session tag keys to pass to any subsequent sessions.
     */
    @JvmName("dsnjmdefnokgxorc")
    public suspend fun transitiveTagKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitiveTagKeys = mapped
    }

    /**
     * @param values Assume role session tag keys to pass to any subsequent sessions.
     */
    @JvmName("eowaulrbrxafscqm")
    public suspend fun transitiveTagKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitiveTagKeys = mapped
    }

    internal fun build(): ProviderAssumeRoleArgs = ProviderAssumeRoleArgs(
        duration = duration,
        externalId = externalId,
        policy = policy,
        policyArns = policyArns,
        roleArn = roleArn,
        sessionName = sessionName,
        sourceIdentity = sourceIdentity,
        tags = tags,
        transitiveTagKeys = transitiveTagKeys,
    )
}
