@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.kotlin.inputs

import com.pulumi.aws.inputs.ProviderDefaultTagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property tags Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
 */
public data class ProviderDefaultTagsArgs(
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.inputs.ProviderDefaultTagsArgs> {
    override fun toJava(): com.pulumi.aws.inputs.ProviderDefaultTagsArgs =
        com.pulumi.aws.inputs.ProviderDefaultTagsArgs.builder()
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProviderDefaultTagsArgs].
 */
@PulumiTagMarker
public class ProviderDefaultTagsArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
     */
    @JvmName("rncofjdyhitlvfsb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
     */
    @JvmName("leglexgjslknmhoe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags to default across all resources. Can also be configured with environment variables like `TF_AWS_DEFAULT_TAGS_<tag_name>`.
     */
    @JvmName("obadmeclqsyxciti")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProviderDefaultTagsArgs = ProviderDefaultTagsArgs(
        tags = tags,
    )
}
